#include <xtl.h>
#include "xbinput.h"
#include <stdio.h>
#include <vector>
using namespace std;
extern void initKeyboard();
extern "C" {
	extern unsigned char ram7fa[65536];
	extern unsigned char ram7f[65536];
	extern unsigned char srama[65536];
}
#include <string>
extern std::string CHEATS_PATH;
extern int keyBoardDraw;
extern void drawXKeyboard();
int drawE = 0;
extern int FileMenuSelected;
#include <vector>
using namespace std;
int keyBoardDisplay = 0;
extern void resetKeyBoard();
struct fileDisplay {
	string name;
	string path;
	bool isAGame;
	bool isARoot;
	bool isADirectory;
	bool topLevel;
	int soundTrack;
	int song;
	int archive;
};
extern int kSlot;
extern int kType;

extern int yO;
extern int zLeftRM;
extern int zTopRM;
extern vector<fileDisplay> fileList;
extern void changePreview();
extern void updateZipFilename();
extern unsigned char leftAnalog;
extern unsigned char rightAnalog;
extern float scrollSpeed;
extern double slow;

extern float scrollSpeed;
//extern unsigned char savePartition;
extern int sWidth;
extern int sHeight;
extern int screenOptions;
extern int screenResize;
extern int screenResizeP;
extern int screenResizeI;
extern int screenResizePB;
extern int screenResizeJ;
extern int zLeftCD;
extern int zTopCD;
extern int screenResizeG;
extern int screenResizeB;
int cheatDBGameSelectedCheat = 0;
int cheatDBGameSelectedCheatAR = 0;
int cheatDBGameSelectedCheatTips = 0;
extern int screenResizeA;
extern int screenResizeA2;
extern int screenResizeS;
extern int screenControllerOptions;
extern int screenCheatOptions;
extern int zLeftCC;
extern int zTopCC;

extern int screenVideoOptions;
extern int screenSoundOptions;
extern int screenLightGunOptions;
extern int screenGeneralOptions;
extern int screenGeneralOptionsGG;
extern int screenGUIOptions;\
extern int screenOptionsM;
extern int screenOptionsHelp;
extern XBGAMEPAD g_Gamepads[4];
extern int inGame;
//extern char fileList[FileMenuSelected].path[260];
int cheatSelected = 0; 
int col = 0; 
int row = 0; 
int Codes[15][8+1+27]; //15 cheats, 8 characters per cheat, 0/1 = On/Off, 27 characters for desc 
extern int GameNameColor;
extern int GameNameSelectedColor;
extern int FolderColor;
extern int MenuOption;
extern int MenuOptionSelected;
extern int FontSizeGUI;
extern int FullNameColor;
extern DWORD menuColor[5];
extern int vSpace;
extern int DisableMenuSounds;
int TwoByte[5];
int OneByte[3];

extern void playEffect(int i);	
int ggCodes[15][8+1+27];
int csCodes[15][8+1+27];

unsigned char prevCodes[15];
unsigned char ggprevCodes[15];
unsigned char csprevCodes[15];
int saveCodes[15];
int ggsaveCodes[15];
int cssaveCodes[15];
int resetCode[15];
int ggresetCode[15];
int csresetCode[15];

int leftXC = 170; 
int yC = 150; 
int cheatDrawn = 0;
extern int FontSetColour(unsigned int colour);
extern int FontText(WCHAR *,int,int, int);
extern int FontSmallText(WCHAR *,int,int, int);
int editCheat = 0;


extern "C" {
	extern unsigned char wramdataa[65536];
	extern unsigned char* romdata;
	//extern unsigned char* sram;
	extern unsigned char ram7fa[65536];
}

int cheatDBMode = 0;
struct cheatEntry {
	string code;
};

struct cheatDBEntry {
	string name;
	vector<cheatEntry> codes;
};

int cheatDBGameSelected = 0;
int cheatDBGameSelectedAR = 0;
int cheatDBGameSelectedTips = 0;
int cheatDBCodeSelected = 0;

vector<cheatDBEntry> codeDatabase;
vector<cheatDBEntry> codeDatabaseAR;
vector<cheatDBEntry> codeDatabaseTips;

void clearCheatCodeListAR() {
	codeDatabaseAR.clear();
}
void buildCheatCodeListAR() {
	codeDatabaseAR.clear();
	FILE* f;
	std::string t = "D:\\database\\proactionreplay.txt";
	f = fopen(t.c_str() , "r");
	int starCount = 0;
	while(true) {
		char line[256];
		fgets(line,256, f);

		if(line[0] == '-' && line[1] == 'E') { fclose(f); return; }

		if(starCount == 1) { //we just read a game title
			//get the name
			starCount = 0;
			cheatDBEntry game;
			for(int z = 0; z < 256; z++)  { if(line[z] == '\n') line[z] = '\0'; }
			game.name =  line; 
			while(true) {
				char line2[1024];
				fgets(line2,1024, f);
				if(line2[0] == '*') break;
				for(int z = 0; z < 1024; z++)  { if(line2[z] == '\n') line2[z] = '\0'; }
				for(int z = 0; z < 1024; z++)  { if(line2[z] == '\t') line2[z] = ' '; }
				std::string n = line2;
				cheatEntry a;
				a.code = n;
				game.codes.push_back(a);
			}
			codeDatabaseAR.push_back(game); 
		}
		if(line[0] == '*')  
			starCount++;
	}
}

void clearCheatCodeListTips() {
	codeDatabaseTips.clear();
}
void buildCheatCodeListTips() {
	codeDatabaseTips.clear();
	//2 stars, game
	//if(game
	FILE* f;
	std::string t = "D:\\database\\tips.txt";
	f = fopen(t.c_str() , "r");


	int stTipsCount = 0;
	while(true) {
		char line[256];
		fgets(line,256, f);

		if(line[0] == '-' && line[1] == 'E') { fclose(f); return; }

		if(stTipsCount == 1) { //we just read a game title
			//get the name
			stTipsCount = 0;
			cheatDBEntry game;
			for(int z = 0; z < 256; z++)  { if(line[z] == '\n') line[z] = '\0'; }
			game.name =  line; 
			char aline2[1024];//read the blank
			fgets(aline2,1024, f);
			while(true) {
				char line2[1024];
				fgets(line2,1024, f);
				if(line2[0] == '*') break;
				for(int z = 0; z < 1024; z++)  { if(line2[z] == '\n') line2[z] = '\0'; }
				for(int z = 0; z < 1024; z++)  { if(line2[z] == '\t') line2[z] = ' '; }


				std::string n = line2;
				cheatEntry a;
				a.code = n;
				game.codes.push_back(a);
			}

			codeDatabaseTips.push_back(game); 
		}
		if(line[0] == '*')  
			stTipsCount++;
	}
}

void clearCheatCodeList() {
	codeDatabase.clear();
}
void buildCheatCodeList() {
	codeDatabase.clear();

	FILE* f;
	std::string t = "D:\\database\\gamegenie.txt";
	f = fopen(t.c_str() , "r");
	int starCount = 0;
	while(true) {
		char line[256];
		fgets(line,256, f);

		if(line[0] == '-' && line[1] == 'E') { fclose(f); return; }

		if(starCount == 1) { //we just read a game title
			//get the name
			starCount = 0;
			cheatDBEntry game;
			for(int z = 0; z < 256; z++)  { if(line[z] == '\n') line[z] = '\0'; }
			game.name =  line; 
			while(true) {
				char line2[1024];
				fgets(line2,1024, f);
				if(line2[0] == '*') break;
				for(int z = 0; z < 1024; z++)  { if(line2[z] == '\n') line2[z] = '\0'; }
				for(int z = 0; z < 1024; z++)  { if(line2[z] == '\t') line2[z] = ' '; }


				std::string n = line2;
				cheatEntry a;
				a.code = n;
				game.codes.push_back(a);
			}

			codeDatabase.push_back(game); 

		}
		if(line[0] == '*')  
			starCount++;
	}
}
void drawListOfGames() {
	int yDB = 110;
	DWORD color;
	int start = 0;

	if(cheatDBGameSelected > 7 && (codeDatabase.size() > 15)) {
		start += (cheatDBGameSelected  - 7);
	}

	if((cheatDBGameSelected > ((codeDatabase.size()-1) - 7)) && (codeDatabase.size() > 15)) {
		start = (codeDatabase.size() - 15);
	}

	for(int i = start; i <  start +15; i++) {
		if(i == codeDatabase.size()) return;
		if(i ==cheatDBGameSelected) color = 0xffff00; else color = 0xffffff; 
		WCHAR atext2345[1024]={0};

		std::string t = ((cheatDBEntry)codeDatabase[i]).name;
		for(int r = 0; r < 1024; r++) {
			if((t.c_str())[r] == '\0') {
				atext2345[r] = '\0';
				break;
			}
			atext2345[r] = (t.c_str())[r];
		}
		FontSetColour(color);
		FontSmallText(atext2345,sWidth/2,yDB, 600);
		yDB+=20;
	}
}


void drawListOfGamesAR() {
	int yDB = 110;
	DWORD color;
	int start = 0;

	if(cheatDBGameSelectedAR > 7 && (codeDatabaseAR.size() > 15)) {
		start += (cheatDBGameSelectedAR  - 7);
	}

	if((cheatDBGameSelectedAR > ((codeDatabaseAR.size()-1) - 7)) && (codeDatabaseAR.size() > 15)) {
		start = (codeDatabaseAR.size() - 15);
	}

	for(int i = start; i <  start +15; i++) {
		if(i == codeDatabaseAR.size()) return;
		if(i ==cheatDBGameSelectedAR) color = 0xffff00; else color = 0xffffff; 
		WCHAR atext2345[1024]={0};

		std::string t = ((cheatDBEntry)codeDatabaseAR[i]).name;
		for(int r = 0; r < 1024; r++) {
			if((t.c_str())[r] == '\0') {
				atext2345[r] = '\0';
				break;
			}
			atext2345[r] = (t.c_str())[r];
		}
		FontSetColour(color);
		FontSmallText(atext2345,sWidth/2,yDB, 600);
		yDB+=20;
	}
}

void drawListOfHeatsAR() {
	int yDB = 110;
	DWORD color;
	int start = 0;

	if(cheatDBGameSelectedCheatAR > 7 && (codeDatabaseAR[cheatDBGameSelectedAR].codes.size() > 15)) {
		start += (cheatDBGameSelectedCheatAR  - 7);
	}

	int aSelected = cheatDBGameSelectedCheatAR;
	int bSizeMinus7 = ((codeDatabaseAR[cheatDBGameSelectedAR].codes.size()-1) - 7);
	if((aSelected > bSizeMinus7) && (codeDatabaseAR[cheatDBGameSelectedAR].codes.size() > 15)) {

		start = (codeDatabaseAR[cheatDBGameSelectedAR].codes.size() - 15);
	}
	for(int i = start; i <  start +15; i++) {
		if(i == codeDatabaseAR[cheatDBGameSelectedAR].codes.size()) { return; }
		if(i ==cheatDBGameSelectedCheatAR) color = 0xffff00; else color = 0xffffff; 
		WCHAR atext2345[1024]={0};
		std::string t2 = codeDatabaseAR[cheatDBGameSelectedAR].codes[i].code;
		int place = t2.find_first_of(":", 0);
		std::string t = t2.substr(place+1, (t2.size()-(place+1)));
		for(int r = 0; r < 1024; r++) {
			if((t.c_str())[r] == '\0') {
				atext2345[r] = '\0';
				break;
			} 
			atext2345[r] = (t.c_str())[r]; 
		}
		FontSetColour(color);
		FontText(atext2345,125+zLeftCD,yDB+zTopCD, -1);
		yDB+=20;
	}
}

void drawListOfGamesTips() {
	int yDB = 110;
	DWORD color;
	int start= 0;

	if(cheatDBGameSelectedTips > 7 && (codeDatabaseTips.size() > 15)) {
		start+= (cheatDBGameSelectedTips  - 7);
	}

	if((cheatDBGameSelectedTips > ((codeDatabaseTips.size()-1) - 7)) && (codeDatabaseTips.size() > 15)) {
		start= (codeDatabaseTips.size() - 15);
	}

	for(int i = start; i <  start+15; i++) {
		if(i == codeDatabaseTips.size()) return;
		if(i ==cheatDBGameSelectedTips) color = 0xffff00; else color = 0xffffff; 
		WCHAR atext2345[1024]={0};

		std::string t = ((cheatDBEntry)codeDatabaseTips[i]).name;
		for(int r = 0; r < 1024; r++) {
			if((t.c_str())[r] == '\0') {
				atext2345[r] = '\0';
				break;
			}
			atext2345[r] = (t.c_str())[r];
		}
		FontSetColour(color);
		FontSmallText(atext2345,sWidth/2,yDB, 600);
		yDB+=20;
	}
}

void drawListOfHeats() {
	int yDB = 110;
	DWORD color;
	int start = 0;

	if(cheatDBGameSelectedCheat > 7 && (codeDatabase[cheatDBGameSelected].codes.size() > 15)) {
		start += (cheatDBGameSelectedCheat  - 7);
	}
	int aSelected = cheatDBGameSelectedCheat;
	int bSizeMinus7 = ((codeDatabase[cheatDBGameSelected].codes.size()-1) - 7);
	if((aSelected > bSizeMinus7) && (codeDatabase[cheatDBGameSelected].codes.size() > 15)) {
		start = (codeDatabase[cheatDBGameSelected].codes.size() - 15);
	}
	for(int i = start; i <  start +15; i++) {
		if(i == codeDatabase[cheatDBGameSelected].codes.size()) { return; }

		if(i ==cheatDBGameSelectedCheat) color = 0xffff00; else color = 0xffffff; 
		WCHAR atext2345[1024]={0};
		std::string t2 = codeDatabase[cheatDBGameSelected].codes[i].code;
		int place = t2.find_first_of(":", 0);
		std::string t = t2.substr(place+1, (t2.size()-(place+1)));




		for(int r = 0; r < 1024; r++) {
			if((t.c_str())[r] == '\0') {
				atext2345[r] = '\0';
				break;
			} 
			atext2345[r] = (t.c_str())[r]; 
		}
		//if(atext2345[0] == '{') atext2345[0] = '-'; 
		FontSetColour(color);
		FontText(atext2345,125+zLeftCD,yDB+zTopCD, -1);
		yDB+=20;
	}
}
void drawListOfHeatsTips() {
	int yDB = 110;
	DWORD color;
	int start = 0;

	if(cheatDBGameSelectedCheatTips > 7 && (codeDatabaseTips[cheatDBGameSelectedTips].codes.size() > 15)) {
		start += (cheatDBGameSelectedCheatTips  - 7);
	}
	int aSelected = cheatDBGameSelectedCheatTips;
	int bSizeMinus7 = ((codeDatabaseTips[cheatDBGameSelectedTips].codes.size()-1) - 7);
	if((aSelected > bSizeMinus7) && (codeDatabaseTips[cheatDBGameSelectedTips].codes.size() > 15)) {
		start = (codeDatabaseTips[cheatDBGameSelectedTips].codes.size() - 15);
	}

	for(int i = start; i <  start+15; i++) {
		if(i == codeDatabaseTips[cheatDBGameSelectedTips].codes.size()) { return; }
		if(codeDatabaseTips[cheatDBGameSelectedTips].codes[i].code[0] == '}') {
			color = 0xff00ff00;
		}
		else {
			color = 0xffffffff;
		}
		if(i ==cheatDBGameSelectedCheatTips) color = 0xffff00; //else color = 0xffffff; 

		WCHAR atext2345[1024]={0};
		std::string t2 = codeDatabaseTips[cheatDBGameSelectedTips].codes[i].code;
		//int place = t2.find_first_of(":", 0);
		std::string t = t2;//.substr(place+1, (t2.size()-(place+1)));
		for(int r = 0; r < 1024; r++) {
			if((t.c_str())[r] == '\0') {
				atext2345[r] = '\0';
				break;
			} 
			atext2345[r] = (t.c_str())[r]; 
		}
		if(atext2345[0] == '}') atext2345[0] = '-'; 
		FontSetColour(color);
		FontText(atext2345,125+zLeftCD,yDB+zTopCD, -1);
		yDB+=20;
	}
}


void drawSelectedGameCodes() {}

extern int cheatSearchMenu;
void drawPickSlot() {
	int plus = 0;
	std::string code = codeDatabase[cheatDBGameSelected].codes[cheatDBGameSelectedCheat].code;
	for(int d = 0; d < 1024; d++) {
		if(code[d] == '\0' || code[d] == '\n')
			break;

		if(code[d] == '+') 
			plus++;
	}

	plus++;
	WCHAR atext2345[280]={0};
	wsprintfW(atext2345,L"This code uses %d slot(s). Please select the first slot", plus);
	//wsprintfW(atext2345,L"Empty slot %d", (i+1));
	FontSetColour(0xffff00);
	FontSmallText(atext2345,sWidth/2,480-55, 600);
	DWORD color = 0xffff00;
	int y = 110;
	for(int i = 0; i < 15; i++) {
		WCHAR atext2345[280]={0};
		if(ggCodes[i][0] == 0 &&
			ggCodes[i][1] == 0 &&
			ggCodes[i][2] == 0 &&
			ggCodes[i][3] == 0) {
				wsprintfW(atext2345,L"Empty slot");// %d", (i+1));
				color = menuColor[MenuOption];

			}
		else {
			wsprintfW(atext2345,L"Code found in this slot");// %d", (i+1));
			color = 0xff00ff00;
		}
		if(cheatSearchMenu == i) color = menuColor[MenuOptionSelected]; //else color = menuColor[MenuOption];
		FontSetColour(color);
		FontSmallText(atext2345,sWidth/2,y, 600);	
		y+=20;
	}
}


void drawPickSlotAR() {
	int plus = 0;
	std::string code = codeDatabaseAR[cheatDBGameSelectedAR].codes[cheatDBGameSelectedCheatAR].code;
	for(int d = 0; d < 1024; d++) {
		if(code[d] == '\0' || code[d] == '\n')
			break;

		if(code[d] == '+') 
			plus++;
	}

	plus++;
	WCHAR atext2345[280]={0};
	wsprintfW(atext2345,L"This code uses %d slot(s). Please select the first slot", plus);
	//wsprintfW(atext2345,L"Empty slot %d", (i+1));
	FontSetColour(0xffff00);
	FontSmallText(atext2345,sWidth/2,480-55, 600);
	DWORD color = 0xffff00;
	int y = 110;
	for(int i = 0; i < 15; i++) {
		WCHAR atext2345[280]={0};
		if(Codes[i][0] == 0 &&
			Codes[i][1] == 0 &&
			Codes[i][2] == 0 &&
			Codes[i][3] == 0) {
				wsprintfW(atext2345,L"Empty slot");// %d", (i+1));
				color = menuColor[MenuOption];

			}
		else {
			wsprintfW(atext2345,L"Code found in this slot");// %d", (i+1));
			color = 0xff00ff00;
		}

		if(cheatSearchMenu == i) color = menuColor[MenuOptionSelected]; //else color = menuColor[MenuOption];
		FontSetColour(color);
		FontSmallText(atext2345,sWidth/2,y, 600);	
		y+=20;
	}
}

void drawCheatCodeList() {
	if(cheatDBMode == 0) { //draw list of games
		drawListOfGames();
		return;
	}

	if(cheatDBMode == 1) { //draw selected games cheat codes
		drawListOfHeats();
		return;
	}

	if(cheatDBMode == 2) { //draw 
		drawPickSlot();
		return;
	}

	//AR
	if(cheatDBMode == 3) { //draw list of games
		drawListOfGamesAR();
		return;
	}

	if(cheatDBMode == 4) { //draw selected games cheat codes
		drawListOfHeatsAR();
		return;
	}

	if(cheatDBMode == 5) { //draw 
		drawPickSlotAR();
		return;
	}

	//Tips
	if(cheatDBMode == 6) { //draw list of games
		drawListOfGamesTips();
		return;
	}

	if(cheatDBMode == 7) { //draw selected games cheat codes
		drawListOfHeatsTips();
		return;
	}
}


class FileMenu
{
public:
	FileMenu();
	int init();
	int scan();
	void exit();
	int render();
	int scroll(int amount);
	int getFilePath(char *name);

private:
	int nameReset();
	int nameFind(char *path);
	int nameAdd(char *entry);
	int nameSizeUp();
	int nameOffset(int index);

	char currentPath[260];
	char *nameList;
	int nameSize,nameMax;
	int nameCount;

	int choiceFocus;
};

extern FileMenu FileMenu;

void saveCheats() {} 

int oneByteCol = 0;
int twoByteCol = 0;

unsigned char getCheatE(int a) { 
	if(a == 0)  return '0'; 
	if(a == 1)  return '1'; 
	if(a == 2)  return '2'; 
	if(a == 3)  return '3'; 
	if(a == 4)  return '4'; 
	if(a == 5)  return '5'; 
	if(a == 6)  return '6'; 
	if(a == 7)  return '7'; 
	if(a == 8)  return '8'; 
	if(a == 9)  return '9'; 
	if(a == 10)  return 'A'; 
	if(a == 11)  return 'B'; 
	if(a == 12)  return 'C'; 
	if(a == 13)  return 'D'; 
	if(a == 14)  return 'E'; 
	if(a == 15)  return 'F'; 

	return '0'; //error default
} 

unsigned char getCheatD(int a) { 
	if(a == 16)  return 'A'; 
	if(a == 17)  return 'B'; 
	if(a == 18)  return 'C'; 
	if(a == 19)  return 'D'; 
	if(a == 20)  return 'E'; 
	if(a == 21)  return 'F'; 
	if(a == 22)  return 'G'; 
	if(a == 23)  return 'H'; 
	if(a == 24)  return 'I'; 
	if(a == 25)  return 'J'; 
	if(a == 26)  return 'K'; 
	if(a == 27)  return 'L'; 
	if(a == 28)  return 'M'; 
	if(a == 29)  return 'N'; 
	if(a == 30)  return 'O'; 
	if(a == 31)  return 'P'; 
	if(a == 32)  return 'Q'; 
	if(a == 33)  return 'R'; 
	if(a == 34)  return 'S'; 
	if(a == 35)  return 'T'; 
	if(a == 36)  return 'U'; 
	if(a == 37)  return 'V'; 
	if(a == 38)  return 'W'; 
	if(a == 39)  return 'X'; 
	if(a == 40)  return 'Y'; 
	if(a == 41)  return 'Z'; 

	if(a == 42)  return 'a'; 
	if(a == 43)  return 'b'; 
	if(a == 44)  return 'c'; 
	if(a == 45)  return 'd'; 
	if(a == 46)  return 'e'; 
	if(a == 47)  return 'f'; 
	if(a == 48)  return 'g'; 
	if(a == 49)  return 'h'; 
	if(a == 50)  return 'i'; 
	if(a == 51)  return 'j'; 
	if(a == 52)  return 'k'; 
	if(a == 53)  return 'l'; 
	if(a == 54)  return 'm'; 
	if(a == 55)  return 'n'; 
	if(a == 56)  return 'o'; 
	if(a == 57)  return 'p'; 
	if(a == 58)  return 'q'; 
	if(a == 59)  return 'r'; 
	if(a == 60)  return 's'; 
	if(a == 61)  return 't'; 
	if(a == 62)  return 'u'; 
	if(a == 63)  return 'v'; 
	if(a == 64)  return 'w'; 
	if(a == 65)  return 'x'; 
	if(a == 66)  return 'y'; 
	if(a == 67)  return 'z'; 

	if(a == 68)  return '0'; 
	if(a == 69)  return '1'; 
	if(a == 70)  return '2'; 
	if(a == 71)  return '3'; 
	if(a == 72)  return '4'; 
	if(a == 73)  return '5'; 
	if(a == 74)  return '6'; 
	if(a == 75)  return '7'; 
	if(a == 76)  return '8'; 
	if(a == 77)  return '9'; 


	if(a == 78)  return ' '; 
	if(a == 79)  return '_'; 
	if(a == 80)  return '('; 
	if(a == 81)  return ')'; 
	if(a == 82)  return '['; 
	if(a == 83)  return ']'; 
	if(a == 84)  return '{'; 
	if(a == 85)  return '}'; 
	if(a == 86)  return ','; 
	if(a == 87)  return '\''; 
	if(a == 88)  return '|'; 
	if(a == 89)  return '+'; 
	if(a == 90)  return '-'; 
	if(a == 91)  return ':'; 
	if(a == 92)  return '<'; 
	if(a == 93)  return '>'; 
	if(a == 94)  return '.'; 
	if(a == 95)  return ';'; 
	if(a == 96)  return '='; 
	if(a == 97)  return '%'; 
	if(a == 98)  return '~'; 
	if(a == 99)  return '!'; 
	if(a == 100)  return '@'; 
	if(a == 101)  return '#'; 
	if(a == 102)  return '$'; 
	if(a == 103)  return '^'; 
	if(a == 104)  return '&'; 
	if(a == 105)  return '*'; 
	if(a == 106)  return '`'; 
	if(a == 107)  return '\\'; 
	if(a == 108)  return '?'; 

	return '?'; 

} 

void writeGGCheatFile() { 
	std::string t = CHEATS_PATH;
	std::string a = fileList[FileMenuSelected].name;
	a[a.size()-3] = 'g';
	a[a.size()-2] = 'g';
	a[a.size()-1] = 'n';
	t = t + a;
	//////dprintf("Cheat name After: %s\n", fnamescheat);

	FILE* f;
	f = fopen((const char*)t.c_str(), "r+");

	if(f == NULL) {
		f = fopen((const char*)t.c_str(), "w");
		fclose(f);
	}
	f = fopen((const char*)t.c_str(), "r+");
	if(f == NULL) return;

	//fprintf(f, "DisableSaveStates=%d\n", DisableSaveStates);
	for(int i = 0; i < 15; i++) { 
		fprintf(f, "%c", getCheatE(ggCodes[i][0])); 
		fprintf(f, "%c", getCheatE(ggCodes[i][1])); 
		fprintf(f, "%c", getCheatE(ggCodes[i][2])); 
		fprintf(f, "%c", getCheatE(ggCodes[i][3])); 
		fprintf(f, "%c", getCheatE(ggCodes[i][4])); 
		fprintf(f, "%c", getCheatE(ggCodes[i][5])); 
		fprintf(f, "%c", getCheatE(ggCodes[i][6])); 
		fprintf(f, "%c", getCheatE(ggCodes[i][7])); 

		fprintf(f, "%c", ':'); 

		fprintf(f, "%c", getCheatE(ggCodes[i][8])); 

		fprintf(f, "%c", ':'); 

		//enter_code_desription_here
		fprintf(f, "%c", getCheatD(ggCodes[i][9])); 
		fprintf(f, "%c", getCheatD(ggCodes[i][10])); 
		fprintf(f, "%c", getCheatD(ggCodes[i][11])); 
		fprintf(f, "%c", getCheatD(ggCodes[i][12])); 
		fprintf(f, "%c", getCheatD(ggCodes[i][13]));

		fprintf(f, "%c", getCheatD(ggCodes[i][14]));
		fprintf(f, "%c", getCheatD(ggCodes[i][15])); 
		fprintf(f, "%c", getCheatD(ggCodes[i][16])); 
		fprintf(f, "%c", getCheatD(ggCodes[i][17])); 
		fprintf(f, "%c", getCheatD(ggCodes[i][18])); 

		fprintf(f, "%c", getCheatD(ggCodes[i][19])); 
		fprintf(f, "%c", getCheatD(ggCodes[i][20])); 
		fprintf(f, "%c", getCheatD(ggCodes[i][21])); 
		fprintf(f, "%c", getCheatD(ggCodes[i][22])); 
		fprintf(f, "%c", getCheatD(ggCodes[i][23])); 

		fprintf(f, "%c", getCheatD(ggCodes[i][24])); 
		fprintf(f, "%c", getCheatD(ggCodes[i][25])); 
		fprintf(f, "%c", getCheatD(ggCodes[i][26])); 
		fprintf(f, "%c", getCheatD(ggCodes[i][27])); 
		fprintf(f, "%c", getCheatD(ggCodes[i][28])); 

		fprintf(f, "%c", getCheatD(ggCodes[i][29])); 
		fprintf(f, "%c", getCheatD(ggCodes[i][30])); 
		fprintf(f, "%c", getCheatD(ggCodes[i][31])); 
		fprintf(f, "%c", getCheatD(ggCodes[i][32])); 
		fprintf(f, "%c", getCheatD(ggCodes[i][33])); 

		fprintf(f, "%c", getCheatD(ggCodes[i][34])); 
		fprintf(f, "%c", getCheatD(ggCodes[i][35])); 

		fprintf(f, "\n"); 
	} 
	fclose(f); 
} 

void writeCSCheatFile() { 
	std::string t = CHEATS_PATH;
	std::string a = fileList[FileMenuSelected].name;
	a[a.size()-3] = 'c';
	a[a.size()-2] = 'c';
	a[a.size()-1] = 's';
	t = t + a;
	
	FILE* f;
	f = fopen((const char*)t.c_str(), "r+");

	if(f == NULL) {
		f = fopen((const char*)t.c_str(), "w");
		fclose(f);
	}
	f = fopen((const char*)t.c_str(), "r+");
	if(f == NULL) return;

	//fprintf(f, "DisableSaveStates=%d\n", DisableSaveStates);
	for(int i = 0; i < 15; i++) { 
		fprintf(f, "%c", getCheatE(csCodes[i][0])); 
		fprintf(f, "%c", getCheatE(csCodes[i][1])); 
		fprintf(f, "%c", getCheatE(csCodes[i][2])); 
		fprintf(f, "%c", getCheatE(csCodes[i][3])); 
		fprintf(f, "%c", getCheatE(csCodes[i][4])); 
		fprintf(f, "%c", getCheatE(csCodes[i][5])); 
		fprintf(f, "%c", getCheatE(csCodes[i][6])); 
		fprintf(f, "%c", getCheatE(csCodes[i][7])); 

		fprintf(f, "%c", ':'); 

		fprintf(f, "%c", getCheatE(csCodes[i][8])); 

		fprintf(f, "%c", ':'); 

		//enter_code_desription_here
		fprintf(f, "%c", getCheatD(csCodes[i][9])); 
		fprintf(f, "%c", getCheatD(csCodes[i][10])); 
		fprintf(f, "%c", getCheatD(csCodes[i][11])); 
		fprintf(f, "%c", getCheatD(csCodes[i][12])); 
		fprintf(f, "%c", getCheatD(csCodes[i][13]));

		fprintf(f, "%c", getCheatD(csCodes[i][14]));
		fprintf(f, "%c", getCheatD(csCodes[i][15])); 
		fprintf(f, "%c", getCheatD(csCodes[i][16])); 
		fprintf(f, "%c", getCheatD(csCodes[i][17])); 
		fprintf(f, "%c", getCheatD(csCodes[i][18])); 

		fprintf(f, "%c", getCheatD(csCodes[i][19])); 
		fprintf(f, "%c", getCheatD(csCodes[i][20])); 
		fprintf(f, "%c", getCheatD(csCodes[i][21])); 
		fprintf(f, "%c", getCheatD(csCodes[i][22])); 
		fprintf(f, "%c", getCheatD(csCodes[i][23])); 

		fprintf(f, "%c", getCheatD(csCodes[i][24])); 
		fprintf(f, "%c", getCheatD(csCodes[i][25])); 
		fprintf(f, "%c", getCheatD(csCodes[i][26])); 
		fprintf(f, "%c", getCheatD(csCodes[i][27])); 
		fprintf(f, "%c", getCheatD(csCodes[i][28])); 

		fprintf(f, "%c", getCheatD(csCodes[i][29])); 
		fprintf(f, "%c", getCheatD(csCodes[i][30])); 
		fprintf(f, "%c", getCheatD(csCodes[i][31])); 
		fprintf(f, "%c", getCheatD(csCodes[i][32])); 
		fprintf(f, "%c", getCheatD(csCodes[i][33])); 

		fprintf(f, "%c", getCheatD(csCodes[i][34])); 
		fprintf(f, "%c", getCheatD(csCodes[i][35])); 

		fprintf(f, "\n"); 
	} 
	fclose(f); 
} 
void writeCheatFile() { 

	writeGGCheatFile();
	writeCSCheatFile();

	std::string t = CHEATS_PATH;
	std::string a = fileList[FileMenuSelected].name;
	a[a.size()-3] = 'p';
	a[a.size()-2] = 'a';
	a[a.size()-1] = 'r';
	t = t + a;
	

	FILE* f;
	f = fopen((const char*)t.c_str(), "r+");

	if(f == NULL) {
		f = fopen((const char*)t.c_str(), "w");
		fclose(f);
	}
	f = fopen((const char*)t.c_str(), "r+");
	if(f == NULL) return;

	if(f == NULL) return;
	//fprintf(f, "DisableSaveStates=%d\n", DisableSaveStates);
	for(int i = 0; i < 15; i++) { 
		fprintf(f, "%c", getCheatE(Codes[i][0])); 
		fprintf(f, "%c", getCheatE(Codes[i][1])); 
		fprintf(f, "%c", getCheatE(Codes[i][2])); 
		fprintf(f, "%c", getCheatE(Codes[i][3])); 
		fprintf(f, "%c", getCheatE(Codes[i][4])); 
		fprintf(f, "%c", getCheatE(Codes[i][5])); 
		fprintf(f, "%c", getCheatE(Codes[i][6])); 
		fprintf(f, "%c", getCheatE(Codes[i][7])); 

		fprintf(f, "%c", ':'); 

		fprintf(f, "%c", getCheatE(Codes[i][8])); 

		fprintf(f, "%c", ':'); 

		//enter_code_desription_here
		fprintf(f, "%c", getCheatD(Codes[i][9])); 
		fprintf(f, "%c", getCheatD(Codes[i][10])); 
		fprintf(f, "%c", getCheatD(Codes[i][11])); 
		fprintf(f, "%c", getCheatD(Codes[i][12])); 
		fprintf(f, "%c", getCheatD(Codes[i][13]));

		fprintf(f, "%c", getCheatD(Codes[i][14]));
		fprintf(f, "%c", getCheatD(Codes[i][15])); 
		fprintf(f, "%c", getCheatD(Codes[i][16])); 
		fprintf(f, "%c", getCheatD(Codes[i][17])); 
		fprintf(f, "%c", getCheatD(Codes[i][18])); 

		fprintf(f, "%c", getCheatD(Codes[i][19])); 
		fprintf(f, "%c", getCheatD(Codes[i][20])); 
		fprintf(f, "%c", getCheatD(Codes[i][21])); 
		fprintf(f, "%c", getCheatD(Codes[i][22])); 
		fprintf(f, "%c", getCheatD(Codes[i][23])); 

		fprintf(f, "%c", getCheatD(Codes[i][24])); 
		fprintf(f, "%c", getCheatD(Codes[i][25])); 
		fprintf(f, "%c", getCheatD(Codes[i][26])); 
		fprintf(f, "%c", getCheatD(Codes[i][27])); 
		fprintf(f, "%c", getCheatD(Codes[i][28])); 

		fprintf(f, "%c", getCheatD(Codes[i][29])); 
		fprintf(f, "%c", getCheatD(Codes[i][30])); 
		fprintf(f, "%c", getCheatD(Codes[i][31])); 
		fprintf(f, "%c", getCheatD(Codes[i][32])); 
		fprintf(f, "%c", getCheatD(Codes[i][33])); 

		fprintf(f, "%c", getCheatD(Codes[i][34])); 
		fprintf(f, "%c", getCheatD(Codes[i][35])); 

		fprintf(f, "\n"); 
	} 
	fclose(f); 


} 

static bool S9xAllHex (const char *code, int len)
{
	for (int i = 0; i < len; i++)
		if ((code [i] < '0' || code [i] > '9') &&
			(code [i] < 'a' || code [i] > 'f') &&
			(code [i] < 'A' || code [i] > 'F'))
			return (false);

	return (true);
}

const char *S9xGameGenieToRaw (const char *code, unsigned int &address, unsigned char &byte)
{
	char new_code [12];

	if (strlen (code) != 9 || *(code + 4) != '-' || !S9xAllHex (code, 4) ||
		!S9xAllHex (code + 5, 4))
		return ("Invalid Game Genie(tm) code - should be 'xxxx-xxxx'.");

	strcpy (new_code, "0x");
	strncpy (new_code + 2, code, 4);
	strcpy (new_code + 6, code + 5);

	static char *real_hex  = "0123456789ABCDEF";
	static char *genie_hex = "DF4709156BC8A23E";

	for (int i = 2; i < 10; i++)
	{
		if (islower (new_code [i]))
			new_code [i] = toupper (new_code [i]);
		int j;
		for (j = 0; j < 16; j++)
		{
			if (new_code [i] == genie_hex [j])
			{
				new_code [i] = real_hex [j];
				break;
			}
		}
		if (j == 16)
			return ("Invalid hex-character in Game Genie(tm) code");
	}
	unsigned int data = 0;
	sscanf (new_code, "%x", &data);
	byte = (unsigned char)(data >> 24);
	address = data & 0xffffff;
	address = ((address & 0x003c00) << 10) +
		((address & 0x00003c) << 14) +
		((address & 0xf00000) >>  8) +
		((address & 0x000003) << 10) +
		((address & 0x00c000) >>  6) +
		((address & 0x0f0000) >> 12) +
		((address & 0x0003c0) >>  6);

	return (NULL);
}


int getCheatCodeB(unsigned char t)  {
	if(t == '1') 
		return 1;
	else
		return 0;

}

int getCheatCodeA(unsigned char t)  {
	if(t == '0') return 0;
	if(t == '1') return 1;
	if(t == '2') return 2;
	if(t == '3') return 3;
	if(t == '4') return 4;
	if(t == '5') return 5;
	if(t == '6') return 6;
	if(t == '7') return 7;
	if(t == '8') return 8;
	if(t == '9') return 9;
	if(t == 'A') return 10;
	if(t == 'B') return 11;
	if(t == 'C') return 12;
	if(t == 'D') return 13;
	if(t == 'E') return 14;
	if(t == 'F') return 15;
	return 0; //default error
}

int getCheatCode(unsigned char t)  {
	if(t == 'A') return 16;
	if(t == 'B') return 17;
	if(t == 'C') return 18;
	if(t == 'D') return 19;
	if(t == 'E') return 20;
	if(t == 'F') return 21;
	if(t == 'G') return 22;
	if(t == 'H') return 23;
	if(t == 'I') return 24;
	if(t == 'J') return 25;
	if(t == 'K') return 26;
	if(t == 'L') return 27;
	if(t == 'M') return 28;
	if(t == 'N') return 29;
	if(t == 'O') return 30;
	if(t == 'P') return 31;
	if(t == 'Q') return 32;
	if(t == 'R') return 33;
	if(t == 'S') return 34;
	if(t == 'T') return 35;
	if(t == 'U') return 36;
	if(t == 'V') return 37;
	if(t == 'W') return 38;
	if(t == 'X') return 39;
	if(t == 'Y') return 40;
	if(t == 'Z') return 41;

	if(t == 'a') return 42;
	if(t == 'b') return 43;
	if(t == 'c') return 44;
	if(t == 'd') return 45;
	if(t == 'e') return 46;
	if(t == 'f') return 47;
	if(t == 'g') return 48;
	if(t == 'h') return 49;
	if(t == 'i') return 50;
	if(t == 'j') return 51;
	if(t == 'k') return 52;
	if(t == 'l') return 53;
	if(t == 'm') return 54;
	if(t == 'n') return 55;
	if(t == 'o') return 56;
	if(t == 'p') return 57;
	if(t == 'q') return 58;
	if(t == 'r') return 59;
	if(t == 's') return 60;
	if(t == 't') return 61;
	if(t == 'u') return 62;
	if(t == 'v') return 63;
	if(t == 'w') return 64;
	if(t == 'x') return 65;
	if(t == 'y') return 66;
	if(t == 'z') return 67;

	if(t == '0') return 68;
	if(t == '1') return 69;
	if(t == '2') return 70;
	if(t == '3') return 71;
	if(t == '4') return 72;
	if(t == '5') return 73;
	if(t == '6') return 74;
	if(t == '7') return 75;
	if(t == '8') return 76;
	if(t == '9') return 77;

	if(t == ' ') return 78; 
	if(t == '_') return 79;
	if(t == '(') return 80;
	if(t == ')') return 81;
	if(t == '[') return 82;
	if(t == ']') return 83;
	if(t == '{') return 84;
	if(t == '}') return 85;
	if(t == ',') return 86;
	if(t == '\'') return 87;
	if(t == '|') return 88;
	if(t == '+') return 89;
	if(t == '-') return 90;
	if(t == ':') return 91;
	if(t == '<') return 92;
	if(t == '>') return 93;
	if(t == '.') return 94;
	if(t == ';') return 95; 
	if(t == '=') return 96; 
	if(t == '%') return 97;
	if(t == '~') return 98;
	if(t == '!') return 99;
	if(t == '@') return 100;
	if(t == '#') return 101;
	if(t == '$') return 102;
	if(t == '^') return 103;
	if(t == '&') return 104;
	if(t == '*') return 105;
	if(t == '`') return 106;
	if(t == '\\') return 107;
	if(t == '?') return 108;

	return 108;
}

int fContinue = 1;
char line[100];

void processLine(int i, int start, int end) {
	for(int j = start; j = end; j++) {
		Codes[i][j]  = 78;
	}
}

void pLine(int l, int i, int s, int e) {
	if(fContinue == 1) {
		if(line[l] == '\n') {
			processLine(i, s, e);
			fContinue = 0;
		}
		else {
			Codes[i][s]  = getCheatCode(line[l]);
		}
	}
}

void loadGGCheat() {
	std::string t = CHEATS_PATH;
	std::string a = fileList[FileMenuSelected].name;
	a[a.size()-3] = 'g';
	a[a.size()-2] = 'g';
	a[a.size()-1] = 'n';
	t = t + a;
	
	FILE* f;
	f = fopen((const char*)t.c_str(), "r");

	//If there is no ini create one with the default values
	if(!f) {
		FILE* f;
		f = fopen((const char*)t.c_str(), "w");
		fclose(f);

		writeCheatFile();
		return;
	}

	for(int i = 0; i < 15; i++) { 
		//00000000:1:Enter_Code_Description_Here 
		for(int i2 = 0; i2 < 100; i2++) line[i2] = '\0'; 
		if(fgets(line, 100, f) != NULL) { 
			ggCodes[i][0] = getCheatCodeA(line[0]); 
			ggCodes[i][1] = getCheatCodeA(line[1]); 
			ggCodes[i][2] = getCheatCodeA(line[2]); 
			ggCodes[i][3] = getCheatCodeA(line[3]); 
			ggCodes[i][4] = getCheatCodeA(line[4]); 
			ggCodes[i][5] = getCheatCodeA(line[5]); 
			ggCodes[i][6] = getCheatCodeA(line[6]); 
			ggCodes[i][7] = getCheatCodeA(line[7]); 
			//Skip : 
			ggCodes[i][8] = getCheatCodeB(line[9]); 
			//Skip : 
			char buffer[27]; 
			int found = 0; 
			for(int g = 0; g < 27; g++) { 
				if(line[g+11] == '\n' || line[g+11] == '\0') { 
					break; 
				} 
				buffer[g] = line[g+11]; 
				found++; 
			} 
			//Enter_Code_Description_Here 
			for(int s = 0; s < 27; s++) ggCodes[i][s+9] = 78; 

			for(int d = 0; d < found; d++) { 
				ggCodes[i][d+9] = getCheatCode(buffer[d]); 
			} 
		} 
	} 
}

void loadCSCheat() {
	std::string t = CHEATS_PATH;
	std::string a = fileList[FileMenuSelected].name;
	a[a.size()-3] = 'c';
	a[a.size()-2] = 'c';
	a[a.size()-1] = 's';
	t = t + a;
	FILE* f;
	f = fopen((const char*)t.c_str(), "r");

	//If there is no ini create one with the default values
	if(!f) {
		FILE* f;
		f = fopen((const char*)t.c_str(), "w");
		fclose(f);

		writeCheatFile();
		return;
	}

	for(int i = 0; i < 15; i++) { 
		//00000000:1:Enter_Code_Description_Here 
		for(int i2 = 0; i2 < 100; i2++) line[i2] = '\0'; 
		if(fgets(line, 100, f) != NULL) { 
			csCodes[i][0] = getCheatCodeA(line[0]); 
			csCodes[i][1] = getCheatCodeA(line[1]); 
			csCodes[i][2] = getCheatCodeA(line[2]); 
			csCodes[i][3] = getCheatCodeA(line[3]); 
			csCodes[i][4] = getCheatCodeA(line[4]); 
			csCodes[i][5] = getCheatCodeA(line[5]); 
			csCodes[i][6] = getCheatCodeA(line[6]); 
			csCodes[i][7] = getCheatCodeA(line[7]); 
			//Skip : 
			csCodes[i][8] = getCheatCodeB(line[9]); 
			//Skip : 
			char buffer[27]; 
			int found = 0; 
			for(int g = 0; g < 27; g++) { 
				if(line[g+11] == '\n' || line[g+11] == '\0') { 
					break; 
				} 
				buffer[g] = line[g+11]; 
				found++; 
			} 
			//Enter_Code_Description_Here 
			for(int s = 0; s < 27; s++) csCodes[i][s+9] = 78; 

			for(int d = 0; d < found; d++) { 
				csCodes[i][d+9] = getCheatCode(buffer[d]); 
			} 
		} 
	} 
}

void loadCheat() {
	std::string t = CHEATS_PATH;
	std::string a = fileList[FileMenuSelected].name;
	a[a.size()-3] = 'p';
	a[a.size()-2] = 'a';
	a[a.size()-1] = 'r';
	t = t + a;
	FILE* f;
	f = fopen((const char*)t.c_str(), "r");

	//If there is no ini create one with the default values
	if(!f) {
		FILE* f;
		f = fopen((const char*)t.c_str(), "w");
		fclose(f);
		writeCheatFile();
		return;
	}

	for(int i = 0; i < 15; i++) { 
		//00000000:1:Enter_Code_Description_Here 
		for(int i2 = 0; i2 < 100; i2++) line[i2] = '\0'; 
		if(fgets(line, 100, f) != NULL) { 
			Codes[i][0] = getCheatCodeA(line[0]); 
			Codes[i][1] = getCheatCodeA(line[1]); 
			Codes[i][2] = getCheatCodeA(line[2]); 
			Codes[i][3] = getCheatCodeA(line[3]); 
			Codes[i][4] = getCheatCodeA(line[4]); 
			Codes[i][5] = getCheatCodeA(line[5]); 
			Codes[i][6] = getCheatCodeA(line[6]); 
			Codes[i][7] = getCheatCodeA(line[7]); 
			//Skip : 
			Codes[i][8] = getCheatCodeB(line[9]); 
			//Skip : 
			char buffer[27]; 
			int found = 0; 
			for(int g = 0; g < 27; g++) { 
				if(line[g+11] == '\n' || line[g+11] == '\0') { 
					break; 
				} 
				buffer[g] = line[g+11]; 
				found++; 
			} 
			//Enter_Code_Description_Here 
			for(int s = 0; s < 27; s++) Codes[i][s+9] = 78; 

			for(int d = 0; d < found; d++) { 
				Codes[i][d+9] = getCheatCode(buffer[d]); 
			} 
		} 
	} 
	loadGGCheat();
	loadCSCheat();
}

void initCheatCodes() { 
	TwoByte[0] = 0;
	TwoByte[1] = 0;
	TwoByte[2] = 0;
	TwoByte[3] = 0;
	TwoByte[4] = 0;

	OneByte[0] = 0;
	OneByte[1] = 0;
	OneByte[2] = 0;

	for(int r = 0; r < 15; r++) { 
		saveCodes[r] = 0;
		ggsaveCodes[r] = 0;
		cssaveCodes[r] = 0;
		prevCodes[r] = 0;
		ggprevCodes[r] = 0;
		csprevCodes[r] = 0;
		resetCode[r] = 0;
		ggresetCode[r] = 0;
		csresetCode[r] = 0;

		for(int c = 0; c < 8; c++) { 
			Codes[r][c] = 0; 
		} 
		Codes[r][8] = 0; //Code off 

		Codes[r][9]  = 20;//'E'; 
		Codes[r][10] = 55;//'n'; 
		Codes[r][11] = 61;//'t'; 
		Codes[r][12] = 46;//'e'; 
		Codes[r][13] = 59;//'r'; 

		Codes[r][14] = 78;//' '; 
		Codes[r][15] = 18;//'C'; 
		Codes[r][16] = 56;//'o'; 
		Codes[r][17] = 45;//'d'; 
		Codes[r][18] = 46;//'e'; 

		Codes[r][19] = 78;//' '; 
		Codes[r][20] = 19;//'D'; 
		Codes[r][21] = 46;//'e'; 
		Codes[r][22] = 60;//'s'; 
		Codes[r][23] = 44;//'c'; 

		Codes[r][24] = 59;//'r'; 
		Codes[r][25] = 50;//'i'; 
		Codes[r][26] = 57;//'p'; 
		Codes[r][27] = 61;//'t'; 
		Codes[r][28] = 50;//'i'; 

		Codes[r][29] = 56;//'o'; 
		Codes[r][30] = 55;//'n'; 
		Codes[r][31] = 78;//' '; 
		Codes[r][32] = 23;//'H'; 
		Codes[r][33] = 46;//'e'; 

		Codes[r][34] = 59;//'r'; 
		Codes[r][35] = 46;//'e'; 


		for(int c = 0; c < 8; c++) { 
			ggCodes[r][c] = 0; 
		} 
		ggCodes[r][8] = 0; //Code off 

		ggCodes[r][9]  = 20;//'E'; 
		ggCodes[r][10] = 55;//'n'; 
		ggCodes[r][11] = 61;//'t'; 
		ggCodes[r][12] = 46;//'e'; 
		ggCodes[r][13] = 59;//'r'; 

		ggCodes[r][14] = 78;//' '; 
		ggCodes[r][15] = 18;//'C'; 
		ggCodes[r][16] = 56;//'o'; 
		ggCodes[r][17] = 45;//'d'; 
		ggCodes[r][18] = 46;//'e'; 

		ggCodes[r][19] = 78;//' '; 
		ggCodes[r][20] = 19;//'D'; 
		ggCodes[r][21] = 46;//'e'; 
		ggCodes[r][22] = 60;//'s'; 
		ggCodes[r][23] = 44;//'c'; 

		ggCodes[r][24] = 59;//'r'; 
		ggCodes[r][25] = 50;//'i'; 
		ggCodes[r][26] = 57;//'p'; 
		ggCodes[r][27] = 61;//'t'; 
		ggCodes[r][28] = 50;//'i'; 

		ggCodes[r][29] = 56;//'o'; 
		ggCodes[r][30] = 55;//'n'; 
		ggCodes[r][31] = 78;//' '; 
		ggCodes[r][32] = 23;//'H'; 
		ggCodes[r][33] = 46;//'e'; 

		ggCodes[r][34] = 59;//'r'; 
		ggCodes[r][35] = 46;//'e'; 

		for(int c = 0; c < 8; c++) { 
			csCodes[r][c] = 0; 
		} 
		csCodes[r][8] = 0; //Code off 

		csCodes[r][9]  = 20;//'E'; 
		csCodes[r][10] = 55;//'n'; 
		csCodes[r][11] = 61;//'t'; 
		csCodes[r][12] = 46;//'e'; 
		csCodes[r][13] = 59;//'r'; 

		csCodes[r][14] = 78;//' '; 
		csCodes[r][15] = 18;//'C'; 
		csCodes[r][16] = 56;//'o'; 
		csCodes[r][17] = 45;//'d'; 
		csCodes[r][18] = 46;//'e'; 

		csCodes[r][19] = 78;//' '; 
		csCodes[r][20] = 19;//'D'; 
		csCodes[r][21] = 46;//'e'; 
		csCodes[r][22] = 60;//'s'; 
		csCodes[r][23] = 44;//'c'; 

		csCodes[r][24] = 59;//'r'; 
		csCodes[r][25] = 50;//'i'; 
		csCodes[r][26] = 57;//'p'; 
		csCodes[r][27] = 61;//'t'; 
		csCodes[r][28] = 50;//'i'; 

		csCodes[r][29] = 56;//'o'; 
		csCodes[r][30] = 55;//'n'; 
		csCodes[r][31] = 78;//' '; 
		csCodes[r][32] = 23;//'H'; 
		csCodes[r][33] = 46;//'e'; 

		csCodes[r][34] = 59;//'r'; 
		csCodes[r][35] = 46;//'e'; 
	} 
} 


int cheatMode = -1;
int cheatMenu = 0;
int cheatMenuSearch = 0;

//--------------------------------------------------------------------------------------------------------------

int cheatSearchMode = 0;
int cheatSearchMenu = 0;
bool oneByteSearch = true;
int cheatResultsFound = 0;

//cheatResultsFound = 600;
unsigned char wram_cheat_old[64 * 1024];
unsigned char ram7f_cheat_old[64 * 1024];
unsigned char sram_cheat_old[64 * 1024];

struct Cheat { 
	unsigned  short address; 
	unsigned char cvalue; 
	unsigned char pvalue;
}; 

vector<Cheat> wramCheats; 
vector<Cheat> ram7fCheats;
vector<Cheat> sramCheats;
int wFlag[64 * 1024];
int rFlag[64 * 1024];
int sFlag[64 * 1024];

void startCheatSearch() {
	wramCheats.clear(); 
	ram7fCheats.clear();
	sramCheats.clear();

	for(int i = 0; i < (64 * 1024); i++) { 
		wram_cheat_old[i] = wramdataa[i]; 
		ram7f_cheat_old[i] = ram7fa[i]; 
		sram_cheat_old[i] = srama[i];
		wFlag[i] = 0;
		rFlag[i] = 0;
		sFlag[i] = 0;
	} 
	return; 
}

void searchForExactValue(unsigned char s) {
	cheatResultsFound = 0;
	wramCheats.clear(); 
	ram7fCheats.clear(); 
	sramCheats.clear();

	for(int i = 0; i < (64 * 1024); i++) { 
		if(wFlag[i] == 0) {
			if(wramdataa[i] == s) {
				Cheat c;
				c.address = i;
				c.cvalue = wramdataa[i];
				c.pvalue = wram_cheat_old[i];
				wramCheats.push_back(c);
			}
			else {
				wFlag[i] = 1;
			}
		}
	} 
	cheatResultsFound = wramCheats.size();

	for(int i = 0; i < (64 * 1024); i++) { 
		wram_cheat_old[i] = wramdataa[i]; 
	}	 


	//wram7f_cheat_old[i] = ram7fa[i]; 
	for(int i = 0; i < (64 * 1024); i++) { 
		if(rFlag[i] == 0) {
			if(ram7fa[i] == s) {
				Cheat c;
				c.address = i;
				c.cvalue = ram7fa[i];
				c.pvalue = ram7f_cheat_old[i];
				ram7fCheats.push_back(c); 
			}
			else {
				rFlag[i] = 1;
			}
		}
	} 
	cheatResultsFound += ram7fCheats.size();

	for(int i = 0; i < (64 * 1024); i++) { 
		ram7f_cheat_old[i] = ram7fa[i]; 
	}	

	for(int i = 0; i < (64 * 1024); i++) { 
		if(sFlag[i] == 0) {
			if(srama[i] == s) {
				Cheat c;
				c.address = i;
				c.cvalue = srama[i];
				c.pvalue = sram_cheat_old[i];
				sramCheats.push_back(c); 
			}
			else {
				sFlag[i] = 1;
			}
		}
	} 
	cheatResultsFound += sramCheats.size();

	for(int i = 0; i < (64 * 1024); i++) { 
		sram_cheat_old[i] = srama[i]; 
	}	 
}

void searchForLessThen() {
	cheatResultsFound = 0;
	wramCheats.clear(); 
	ram7fCheats.clear();
	sramCheats.clear();
	for(int i = 0; i < (64 * 1024); i++) { 
		if(wFlag[i] == 0) {
			if(wramdataa[i] < wram_cheat_old[i]) {
				Cheat c;
				c.address = i;
				c.cvalue = wramdataa[i];
				c.pvalue = wram_cheat_old[i];
				wramCheats.push_back(c); 
			}
			else {
				wFlag[i] = 1;
			}
		}
	} 
	cheatResultsFound = wramCheats.size();

	for(int i = 0; i < (64 * 1024); i++) { 
		wram_cheat_old[i] = wramdataa[i]; 
	}	 

	for(int i = 0; i < (64 * 1024); i++) { 
		if(rFlag[i] == 0) {
			if(ram7fa[i] < ram7f_cheat_old[i]) {
				Cheat c;
				c.address = i;
				c.cvalue = ram7fa[i];
				c.pvalue = ram7f_cheat_old[i];
				ram7fCheats.push_back(c); 
			}
			else {
				rFlag[i] = 1;
			}
		}
	} 
	cheatResultsFound += ram7fCheats.size();

	for(int i = 0; i < (64 * 1024); i++) { 
		ram7f_cheat_old[i] = ram7fa[i]; 
	}	 

	for(int i = 0; i < (64 * 1024); i++) { 
		if(sFlag[i] == 0) {
			if(srama[i] < sram_cheat_old[i]) {
				Cheat c;
				c.address = i;
				c.cvalue = srama[i];
				c.pvalue = sram_cheat_old[i];
				sramCheats.push_back(c); 
			}
			else {
				sFlag[i] = 1;
			}
		}
	} 
	cheatResultsFound += sramCheats.size();

	for(int i = 0; i < (64 * 1024); i++) { 
		sram_cheat_old[i] = srama[i]; 
	}	 
}

void searchForLessThenEqual() {
	cheatResultsFound = 0;
	wramCheats.clear(); 
	ram7fCheats.clear();
	sramCheats.clear();
	for(int i = 0; i < (64 * 1024); i++) { 
		if(wFlag[i] == 0) {
			if(wramdataa[i] <= wram_cheat_old[i]) {
				Cheat c;
				c.address = i;
				c.cvalue = wramdataa[i];
				c.pvalue = wram_cheat_old[i];
				wramCheats.push_back(c); 
			}
			else {
				wFlag[i] = 1;
			}
		}
	} 
	cheatResultsFound = wramCheats.size();

	for(int i = 0; i < (64 * 1024); i++) { 
		wram_cheat_old[i] = wramdataa[i]; 
	}	 

	for(int i = 0; i < (64 * 1024); i++) { 
		if(rFlag[i] == 0) {
			if(ram7fa[i] <= ram7f_cheat_old[i]) {
				Cheat c;
				c.address = i;
				c.cvalue = ram7fa[i];
				c.pvalue = ram7f_cheat_old[i];
				ram7fCheats.push_back(c); 
			}
			else {
				rFlag[i] = 1;
			}
		}
	} 
	cheatResultsFound += ram7fCheats.size();

	for(int i = 0; i < (64 * 1024); i++) { 
		ram7f_cheat_old[i] = ram7fa[i]; 
	}	 

	for(int i = 0; i < (64 * 1024); i++) { 
		if(sFlag[i] == 0) {
			if(srama[i] <= sram_cheat_old[i]) {
				Cheat c;
				c.address = i;
				c.cvalue = srama[i];
				c.pvalue = sram_cheat_old[i];
				sramCheats.push_back(c); 
			}
			else {
				sFlag[i] = 1;
			}
		}
	} 
	cheatResultsFound += sramCheats.size();

	for(int i = 0; i < (64 * 1024); i++) { 
		sram_cheat_old[i] = srama[i]; 
	}	 
}

void searchForGreaterThen() { 
	cheatResultsFound = 0;
	wramCheats.clear(); 
	ram7fCheats.clear();
	sramCheats.clear();
	for(int i = 0; i < (64 * 1024); i++) { 
		if(wFlag[i] == 0) {
			if(wramdataa[i] > wram_cheat_old[i]) {
				Cheat c;
				c.address = i;
				c.cvalue = wramdataa[i];
				c.pvalue = wram_cheat_old[i];
				wramCheats.push_back(c); 
			}
			else {
				wFlag[i] = 1;
			}
		}
	} 
	cheatResultsFound = wramCheats.size();

	for(int i = 0; i < (64 * 1024); i++) { 
		wram_cheat_old[i] = wramdataa[i]; 
	}	 

	for(int i = 0; i < (64 * 1024); i++) { 
		if(rFlag[i] == 0) {
			if(ram7fa[i] > ram7f_cheat_old[i]) {
				Cheat c;
				c.address = i;
				c.cvalue = ram7fa[i];
				c.pvalue = ram7f_cheat_old[i];
				ram7fCheats.push_back(c); 
			}
			else {
				rFlag[i] = 1;
			}
		}
	} 
	cheatResultsFound += ram7fCheats.size();

	for(int i = 0; i < (64 * 1024); i++) { 
		ram7f_cheat_old[i] = ram7fa[i]; 
	}	 

	for(int i = 0; i < (64 * 1024); i++) { 
		if(sFlag[i] == 0) {
			if(srama[i] > sram_cheat_old[i]) {
				Cheat c;
				c.address = i;
				c.cvalue = srama[i];
				c.pvalue = sram_cheat_old[i];
				sramCheats.push_back(c); 
			}
			else {
				sFlag[i] = 1;
			}
		}
	} 
	cheatResultsFound += sramCheats.size();

	for(int i = 0; i < (64 * 1024); i++) { 
		sram_cheat_old[i] = srama[i]; 
	}	 
}

void searchForGreaterThenEqual() { 
	cheatResultsFound = 0;
	wramCheats.clear(); 
	ram7fCheats.clear();
	sramCheats.clear();
	for(int i = 0; i < (64 * 1024); i++) { 
		if(wFlag[i] == 0) {
			if(wramdataa[i] >= wram_cheat_old[i]) {
				Cheat c;
				c.address = i;
				c.cvalue = wramdataa[i];
				c.pvalue = wram_cheat_old[i];
				wramCheats.push_back(c); 
			}
			else {
				wFlag[i] = 1;
			}
		}
	} 
	cheatResultsFound = wramCheats.size();

	for(int i = 0; i < (64 * 1024); i++) { 
		wram_cheat_old[i] = wramdataa[i]; 
	}	 

	for(int i = 0; i < (64 * 1024); i++) { 
		if(rFlag[i] == 0) {
			if(ram7fa[i] >= ram7f_cheat_old[i]) {
				Cheat c;
				c.address = i;
				c.cvalue = ram7fa[i];
				c.pvalue = ram7f_cheat_old[i];
				ram7fCheats.push_back(c); 
			}
			else {
				rFlag[i] = 1;
			}
		}
	} 
	cheatResultsFound += ram7fCheats.size();

	for(int i = 0; i < (64 * 1024); i++) { 
		ram7f_cheat_old[i] = ram7fa[i]; 
	}	 

	for(int i = 0; i < (64 * 1024); i++) { 
		if(sFlag[i] == 0) {
			if(srama[i] >= sram_cheat_old[i]) {
				Cheat c;
				c.address = i;
				c.cvalue = srama[i];
				c.pvalue = sram_cheat_old[i];
				sramCheats.push_back(c); 
			}
			else {
				sFlag[i] = 1;
			}
		}
	} 
	cheatResultsFound += sramCheats.size();

	for(int i = 0; i < (64 * 1024); i++) { 
		sram_cheat_old[i] = srama[i]; 
	}	 
}

void searchForNotEqual() { 
	cheatResultsFound = 0;
	wramCheats.clear(); 
	ram7fCheats.clear();
	sramCheats.clear();
	for(int i = 0; i < (64 * 1024); i++) { 
		if(wFlag[i] == 0) {
			if(wramdataa[i] != wram_cheat_old[i]) {
				Cheat c;
				c.address = i;
				c.cvalue = wramdataa[i];
				c.pvalue = wram_cheat_old[i];
				wramCheats.push_back(c); 
			}
			else {
				wFlag[i] = 1;
			}
		}
	} 
	cheatResultsFound = wramCheats.size();

	for(int i = 0; i < (64 * 1024); i++) { 
		wram_cheat_old[i] = wramdataa[i]; 
	}	 

	for(int i = 0; i < (64 * 1024); i++) { 
		if(rFlag[i] == 0) {
			if(ram7fa[i] != ram7f_cheat_old[i]) {
				Cheat c;
				c.address = i;
				c.cvalue = ram7fa[i];
				c.pvalue = ram7f_cheat_old[i];
				ram7fCheats.push_back(c); 
			}
			else {
				rFlag[i] = 1;
			}
		}
	} 
	cheatResultsFound += ram7fCheats.size();

	for(int i = 0; i < (64 * 1024); i++) { 
		ram7f_cheat_old[i] = ram7fa[i]; 
	}	 

	for(int i = 0; i < (64 * 1024); i++) { 
		if(sFlag[i] == 0) {
			if(srama[i] != sram_cheat_old[i]) {
				Cheat c;
				c.address = i;
				c.cvalue = srama[i];
				c.pvalue = sram_cheat_old[i];
				sramCheats.push_back(c); 
			}
			else {
				sFlag[i] = 1;
			}
		}
	} 
	cheatResultsFound += sramCheats.size();

	for(int i = 0; i < (64 * 1024); i++) { 
		sram_cheat_old[i] = srama[i]; 
	}	 
}

void searchForEqual() { 
	cheatResultsFound = 0;
	wramCheats.clear(); 
	ram7fCheats.clear();
	sramCheats.clear();
	for(int i = 0; i < (64 * 1024); i++) { 
		if(wFlag[i] == 0) {
			if(wramdataa[i] == wram_cheat_old[i]) {
				Cheat c;
				c.address = i;
				c.cvalue = wramdataa[i];
				c.pvalue = wram_cheat_old[i];
				wramCheats.push_back(c); 
			}
			else {
				wFlag[i] = 1;
			}
		}
	} 
	cheatResultsFound = wramCheats.size();

	for(int i = 0; i < (64 * 1024); i++) { 
		wram_cheat_old[i] = wramdataa[i]; 
	}	 

	for(int i = 0; i < (64 * 1024); i++) { 
		if(rFlag[i] == 0) {
			if(ram7fa[i] == ram7f_cheat_old[i]) {
				Cheat c;
				c.address = i;
				c.cvalue = ram7fa[i];
				c.pvalue = ram7f_cheat_old[i];
				ram7fCheats.push_back(c); 
			}
			else {
				rFlag[i] = 1;
			}
		}
	} 
	cheatResultsFound += ram7fCheats.size();

	for(int i = 0; i < (64 * 1024); i++) { 
		ram7f_cheat_old[i] = ram7fa[i]; 
	}	 

	for(int i = 0; i < (64 * 1024); i++) { 
		if(sFlag[i] == 0) {
			if(srama[i] == sram_cheat_old[i]) {
				Cheat c;
				c.address = i;
				c.cvalue = srama[i];
				c.pvalue = sram_cheat_old[i];
				sramCheats.push_back(c); 
			}
			else {
				sFlag[i] = 1;
			}
		}
	} 
	cheatResultsFound += sramCheats.size();

	for(int i = 0; i < (64 * 1024); i++) { 
		sram_cheat_old[i] = srama[i]; 
	}	 
}

int cheatSelectedAddress = 0;

int checkValue() {
	int t = 0;
	if(oneByteSearch == true) {
		char q[4];
		q[3] = '\0';

		if(OneByte[0] == 0) q[0] = '0';
		if(OneByte[0] == 1) q[0] = '1';
		if(OneByte[0] == 2) q[0] = '2';
		if(OneByte[0] == 3) q[0] = '3';
		if(OneByte[0] == 4) q[0] = '4';
		if(OneByte[0] == 5) q[0] = '5';
		if(OneByte[0] == 6) q[0] = '6';
		if(OneByte[0] == 7) q[0] = '7';
		if(OneByte[0] == 8) q[0] = '8';
		if(OneByte[0] == 9) q[0] = '9';

		if(OneByte[1] == 0) q[1] = '0';
		if(OneByte[1] == 1) q[1] = '1';
		if(OneByte[1] == 2) q[1] = '2';
		if(OneByte[1] == 3) q[1] = '3';
		if(OneByte[1] == 4) q[1] = '4';
		if(OneByte[1] == 5) q[1] = '5';
		if(OneByte[1] == 6) q[1] = '6';
		if(OneByte[1] == 7) q[1] = '7';
		if(OneByte[1] == 8) q[1] = '8';
		if(OneByte[1] == 9) q[1] = '9';

		if(OneByte[2] == 0) q[2] = '0';
		if(OneByte[2] == 1) q[2] = '1';
		if(OneByte[2] == 2) q[2] = '2';
		if(OneByte[2] == 3) q[2] = '3';
		if(OneByte[2] == 4) q[2] = '4';
		if(OneByte[2] == 5) q[2] = '5';
		if(OneByte[2] == 6) q[2] = '6';
		if(OneByte[2] == 7) q[2] = '7';
		if(OneByte[2] == 8) q[2] = '8';
		if(OneByte[2] == 9) q[2] = '9';

		t = (int) atoi(q);
		if(t > 255 || t < 0) return -1; else return t;
	}
	else {
		char q[6];
		q[5] = '\0';

		if(TwoByte[0] == 0) q[0] = '0';
		if(TwoByte[0] == 1) q[0] = '1';
		if(TwoByte[0] == 2) q[0] = '2';
		if(TwoByte[0] == 3) q[0] = '3';
		if(TwoByte[0] == 4) q[0] = '4';
		if(TwoByte[0] == 5) q[0] = '5';
		if(TwoByte[0] == 6) q[0] = '6';
		if(TwoByte[0] == 7) q[0] = '7';
		if(TwoByte[0] == 8) q[0] = '8';
		if(TwoByte[0] == 9) q[0] = '9';

		if(TwoByte[1] == 0) q[1] = '0';
		if(TwoByte[1] == 1) q[1] = '1';
		if(TwoByte[1] == 2) q[1] = '2';
		if(TwoByte[1] == 3) q[1] = '3';
		if(TwoByte[1] == 4) q[1] = '4';
		if(TwoByte[1] == 5) q[1] = '5';
		if(TwoByte[1] == 6) q[1] = '6';
		if(TwoByte[1] == 7) q[1] = '7';
		if(TwoByte[1] == 8) q[1] = '8';
		if(TwoByte[1] == 9) q[1] = '9';

		if(TwoByte[2] == 0) q[2] = '0';
		if(TwoByte[2] == 1) q[2] = '1';
		if(TwoByte[2] == 2) q[2] = '2';
		if(TwoByte[2] == 3) q[2] = '3';
		if(TwoByte[2] == 4) q[2] = '4';
		if(TwoByte[2] == 5) q[2] = '5';
		if(TwoByte[2] == 6) q[2] = '6';
		if(TwoByte[2] == 7) q[2] = '7';
		if(TwoByte[2] == 8) q[2] = '8';
		if(TwoByte[2] == 9) q[2] = '9';

		if(TwoByte[3] == 0) q[3] = '0';
		if(TwoByte[3] == 1) q[3] = '1';
		if(TwoByte[3] == 2) q[3] = '2';
		if(TwoByte[3] == 3) q[3] = '3';
		if(TwoByte[3] == 4) q[3] = '4';
		if(TwoByte[3] == 5) q[3] = '5';
		if(TwoByte[3] == 6) q[3] = '6';
		if(TwoByte[3] == 7) q[3] = '7';
		if(TwoByte[3] == 8) q[3] = '8';
		if(TwoByte[3] == 9) q[3] = '9';

		if(TwoByte[4] == 0) q[4] = '0';
		if(TwoByte[4] == 1) q[4] = '1';
		if(TwoByte[4] == 2) q[4] = '2';
		if(TwoByte[4] == 3) q[4] = '3';
		if(TwoByte[4] == 4) q[4] = '4';
		if(TwoByte[4] == 5) q[4] = '5';
		if(TwoByte[4] == 6) q[4] = '6';
		if(TwoByte[4] == 7) q[4] = '7';
		if(TwoByte[4] == 8) q[4] = '8';
		if(TwoByte[4] == 9) q[4] = '9';
		t = (int) atoi(q);
		if(t > 65535 || t < 0) return -1; else return t;
	}
}

void processCheatSearchOptions() {
	//Start/Continue
	if(cheatSearchMode == 0) {
		if(g_Gamepads[0].Event == XBGAMEPAD_B) { 
			if(DisableMenuSounds == 0) playEffect(1); 
			cheatMode = -1; 
			cheatSearchMenu = 0;
			cheatSearchMode = 0;
			return; 
		}
		if(g_Gamepads[0].Event == XBGAMEPAD_DPAD_UP) { 
			if(DisableMenuSounds == 0) playEffect(0);	cheatSearchMenu--; if(cheatSearchMenu < 0) cheatSearchMenu = 1;
		}
		if(g_Gamepads[0].Event == XBGAMEPAD_DPAD_DOWN) { 
			if(DisableMenuSounds == 0) playEffect(0);	cheatSearchMenu++; if(cheatSearchMenu > 1) cheatSearchMenu = 0;
		}
		if(g_Gamepads[0].Event == XBGAMEPAD_A) { 
			if(DisableMenuSounds == 0) playEffect(2);
			if(cheatSearchMenu == 0) { //start new search
				cheatResultsFound = 0; 
				//save all current RAM data
				startCheatSearch(); 
				cheatSearchMenu = 0;
				cheatSearchMode = 2;//1;
				return; 
			}

			if(cheatSearchMenu == 1) {//continue a search
				cheatSearchMode = 3;
				cheatSearchMenu = 0;
				return;
			}
		}
	}
	if(cheatSearchMode == 2) {
		if(g_Gamepads[0].Event == XBGAMEPAD_A) { 
			if(DisableMenuSounds == 0) playEffect(2); 
			cheatSearchMode = 0;
			cheatSearchMenu = 0;
			return; 
		}
	}

	if(cheatSearchMode == 3) {
		if(g_Gamepads[0].Event == XBGAMEPAD_B) { 
			if(DisableMenuSounds == 0) playEffect(1); 
			cheatSearchMode = 0;
			cheatSearchMenu = 1;
			return; 
		}
		//=, <, <=, >, >=, !=
		if(g_Gamepads[0].Event == XBGAMEPAD_DPAD_UP) { 
			if(DisableMenuSounds == 0) playEffect(0);	cheatSearchMenu--; if(cheatSearchMenu < 0) cheatSearchMenu = 6;
		}
		if(g_Gamepads[0].Event == XBGAMEPAD_DPAD_DOWN) { 
			if(DisableMenuSounds == 0) playEffect(0);	cheatSearchMenu++; if(cheatSearchMenu > 6) cheatSearchMenu = 0;
		}
		if(g_Gamepads[0].Event == XBGAMEPAD_A) { 
			if(DisableMenuSounds == 0) playEffect(2); 


			//Handle cheat search
			if(cheatSearchMenu == 0) { //enter exact value
				cheatSearchMode = 4;
				TwoByte[0] = 0;
				TwoByte[1] = 0;
				TwoByte[2] = 0;
				TwoByte[3] = 0;
				TwoByte[4] = 0;

				OneByte[0] = 0;
				OneByte[1] = 0;
				OneByte[2] = 0;
				return;
			}

			if(cheatSearchMenu == 1) searchForLessThen();
			if(cheatSearchMenu == 2) searchForLessThenEqual();
			if(cheatSearchMenu == 3) searchForGreaterThen();
			if(cheatSearchMenu == 4) searchForGreaterThenEqual();
			if(cheatSearchMenu == 5) searchForNotEqual();
			if(cheatSearchMenu == 6) searchForEqual();

			if(cheatResultsFound <= 15 && cheatResultsFound != 0) {
				cheatSearchMode = 5;
			}
			else {
				cheatSearchMode = 6;
			}
			return; 
		}
		return;
	}


	if(cheatSearchMode == 4) {
		//if(oneByteSearch == true) {
		if(g_Gamepads[0].Event == XBGAMEPAD_DPAD_LEFT) { 
			if(DisableMenuSounds == 0) playEffect(0);	oneByteCol--; if(oneByteCol < 0) oneByteCol = 2; } 
		if(g_Gamepads[0].Event == XBGAMEPAD_DPAD_RIGHT) { 
			if(DisableMenuSounds == 0) playEffect(0);	oneByteCol++; if(oneByteCol > 2) oneByteCol = 0; } 

		if(g_Gamepads[0].Event == XBGAMEPAD_A) { //Increase value 
			if(DisableMenuSounds == 0) playEffect(2);
			OneByte[oneByteCol]++;  if(OneByte[oneByteCol] > 9) OneByte[oneByteCol] = 0; //Increase the value of this digit
		}
		if(g_Gamepads[0].Event == XBGAMEPAD_X) { //Decrease value 
			if(DisableMenuSounds == 0) playEffect(2);
			OneByte[oneByteCol]--;  if(OneByte[oneByteCol] < 0) OneByte[oneByteCol] = 9;
		}

		if(g_Gamepads[0].Event == XBGAMEPAD_Y) { //Search 
			if(DisableMenuSounds == 0) playEffect(2);
			int s = checkValue();
			if(s == -1) {
				cheatSearchMode = 7;
				return;
			}
			searchForExactValue(s);

			if(cheatResultsFound <= 15 && cheatResultsFound != 0) {
				cheatSearchMode = 5;
				return;
			}
			else {
				cheatSearchMode = 6;
				return;
			}
		}

		if(g_Gamepads[0].Event == XBGAMEPAD_B) { //Cancel 
			if(DisableMenuSounds == 0) playEffect(1);
			cheatSearchMode = 3;
			return;
		}

	}

	if(cheatSearchMode == 5) {
		//process codes found
		if(g_Gamepads[0].Event == XBGAMEPAD_A) { 
			if(DisableMenuSounds == 0) playEffect(2);
			cheatSearchMode = 8;
			cheatSearchMenu = 0;
			return;
		}
	}

	if(cheatSearchMode == 6) {
		if(g_Gamepads[0].Event == XBGAMEPAD_A) { 
			if(DisableMenuSounds == 0) playEffect(2);
			cheatSearchMode = 3;
			//cheatSearchMenu = 0;
			return;
		}
	}

	if(cheatSearchMode == 7) {
		if(g_Gamepads[0].Event == XBGAMEPAD_A) { 
			if(DisableMenuSounds == 0) playEffect(2);
			cheatSearchMode = 4;
			cheatSearchMenu = 0;
			return;
		}
	}

	if(cheatSearchMode == 8) {
		//process codes found
		if(g_Gamepads[0].Event == XBGAMEPAD_B) { 
			if(DisableMenuSounds == 0) playEffect(1);
			cheatSearchMode = 3;
			cheatSearchMenu = 0;
			return;
		}
		if(g_Gamepads[0].Event == XBGAMEPAD_DPAD_UP) { 
			if(DisableMenuSounds == 0) playEffect(0);	
			cheatSearchMenu--; if(cheatSearchMenu < 0 ) cheatSearchMenu = ((wramCheats.size() + ram7fCheats.size()) - 1);

		}
		if(g_Gamepads[0].Event == XBGAMEPAD_DPAD_DOWN) { 
			if(DisableMenuSounds == 0) playEffect(0);	
			cheatSearchMenu++; if(cheatSearchMenu > ((wramCheats.size() + ram7fCheats.size()) - 1)) cheatSearchMenu = 0;
		}
		if(g_Gamepads[0].Event == XBGAMEPAD_A) { 
			if(DisableMenuSounds == 0) playEffect(2);
			cheatSelectedAddress = cheatSearchMenu;
			cheatSearchMode = 9;
			cheatSearchMenu = 0;
			OneByte[0] = 0;
			OneByte[1] = 0;
			OneByte[2] = 0;
			return;
		}
	}

	if(cheatSearchMode == 9) {
		//if(oneByteSearch == true) {
		if(g_Gamepads[0].Event == XBGAMEPAD_DPAD_LEFT) { 
			if(DisableMenuSounds == 0) playEffect(0);	oneByteCol--; if(oneByteCol < 0) oneByteCol = 2; } 
		if(g_Gamepads[0].Event == XBGAMEPAD_DPAD_RIGHT) { 
			if(DisableMenuSounds == 0) playEffect(0);	oneByteCol++; if(oneByteCol > 2) oneByteCol = 0; } 

		if(g_Gamepads[0].Event == XBGAMEPAD_A) { //Increase value 
			if(DisableMenuSounds == 0) playEffect(2);
			OneByte[oneByteCol]++;  if(OneByte[oneByteCol] > 9) OneByte[oneByteCol] = 0; //Increase the value of this digit
		}
		if(g_Gamepads[0].Event == XBGAMEPAD_X) { //Decrease value 
			if(DisableMenuSounds == 0) playEffect(2);
			OneByte[oneByteCol]--;  if(OneByte[oneByteCol] < 0) OneByte[oneByteCol] = 9;
		}

		if(g_Gamepads[0].Event == XBGAMEPAD_Y) { //Go to Pick a slot 
			if(DisableMenuSounds == 0) playEffect(2);
			int s = checkValue();
			if(s == -1) {
				cheatSearchMode = 10;
				return;
			}
			cheatSearchMode = 11;
			return;
		}

		if(g_Gamepads[0].Event == XBGAMEPAD_B) { //Cancel 
			if(DisableMenuSounds == 0) playEffect(1);
			cheatSearchMode = 8;
			return;
		}
	}

	if(cheatSearchMode == 10) {
		if(g_Gamepads[0].Event == XBGAMEPAD_A) { 
			if(DisableMenuSounds == 0) playEffect(2);
			cheatSearchMode = 9;
			cheatSearchMenu = 0;
			return;
		}
	}

	if(cheatSearchMode == 11) {
		if(g_Gamepads[0].Event == XBGAMEPAD_B) { 
			if(DisableMenuSounds == 0) playEffect(1); 
			cheatSearchMode = 9;
			cheatSearchMenu = 0;
			return; 
		}
		//=, <, <=, >, >=, !=
		if(g_Gamepads[0].Event == XBGAMEPAD_DPAD_UP) { 
			if(DisableMenuSounds == 0) playEffect(0);	cheatSearchMenu--; if(cheatSearchMenu < 0) cheatSearchMenu = 14;
		}
		if(g_Gamepads[0].Event == XBGAMEPAD_DPAD_DOWN) { 
			if(DisableMenuSounds == 0) playEffect(0);	cheatSearchMenu++; if(cheatSearchMenu > 14) cheatSearchMenu = 0;
		}
		if(g_Gamepads[0].Event == XBGAMEPAD_A) { 
			if(DisableMenuSounds == 0) playEffect(2);
			//create the code
			int area = 0;
			unsigned short a = 0;

			int w = wramCheats.size();
			int r = ram7fCheats.size();

			if(cheatSelectedAddress < w) {
				a = wramCheats[cheatSelectedAddress].address;
				area = 0;
			}

			if(cheatSelectedAddress >= w && cheatSelectedAddress < (w + r)) {
				a = ram7fCheats[cheatSelectedAddress - w].address;
				area = 1;
			}

			if(cheatSelectedAddress >= (w + r)) {
				a = sramCheats[cheatSelectedAddress - (w + r)].address;
				area = 2;
			}
			csCodes[cheatSearchMenu][0] = 0;
			csCodes[cheatSearchMenu][1] = area;
			
			//FFFF
			csCodes[cheatSearchMenu][2] = (a & 0xF000) >> 12;
			csCodes[cheatSearchMenu][3] = (a & 0x0F00) >> 8;
			csCodes[cheatSearchMenu][4] = (a & 0x00F0) >> 4;
			csCodes[cheatSearchMenu][5] = (a & 0x000F);

			//(csCodes[r][6] << 4)  |  csCodes[r][7];
			int c2 = (OneByte[0] * 100) + (OneByte[1] * 10) + OneByte[2]; 
			csCodes[cheatSearchMenu][6] = c2 >> 4;
			csCodes[cheatSearchMenu][7] = c2 & 0x0F;

			csCodes[cheatSearchMenu][8] = 0; //Off

			//allow the user to create another code from this batch
			cheatSearchMode = 12;
			cheatSearchMenu = 0;
			return;
		}
	}

	if(cheatSearchMode == 12) {
		if(g_Gamepads[0].Event == XBGAMEPAD_A) { 
			if(DisableMenuSounds == 0) playEffect(2);
			cheatSearchMode = 8;
			cheatSearchMenu = 0;
			return;
		}
	}
}	

extern unsigned char leftAnalog;
extern unsigned char rightAnalog;
//-------------------------------------------------------------------------------------------------------------
double slow = 0;
double slowAR = 0;
double slowTips = 0;
void processCheatOptions() { 
	if(cheatMode == 4) {
		processCheatSearchOptions();
		return;
	}
	//Main menu exit
	if(g_Gamepads[0].Event == XBGAMEPAD_B  && cheatMode == -1) { 
		if(DisableMenuSounds == 0) playEffect(1); writeCheatFile();
		screenCheatOptions = 0; screenOptions = 1;
		return; 
	}

	if(g_Gamepads[0].Event == XBGAMEPAD_B  && cheatMode == 5 && cheatDBMode == 0) { 
		if(DisableMenuSounds == 0) playEffect(1); writeCheatFile();
		cheatMode = -1;	   
		clearCheatCodeList();
		return; 
	}


	if((g_Gamepads[0].Event == XBGAMEPAD_B) && (cheatMode == 5) && (cheatDBMode == 1)) { 
		if(DisableMenuSounds == 0) playEffect(1); writeCheatFile();
		cheatDBMode = 0;	   return; 
	}



	if(g_Gamepads[0].Event == XBGAMEPAD_B  && cheatMode == 5 && cheatDBMode == 3) { 
		if(DisableMenuSounds == 0) playEffect(1); writeCheatFile();
		cheatMode = -1;	  
		clearCheatCodeListAR();
		return; 
	}


	if((g_Gamepads[0].Event == XBGAMEPAD_B) && (cheatMode == 5) && (cheatDBMode == 4)) { 
		if(DisableMenuSounds == 0) playEffect(1); writeCheatFile();
		cheatDBMode = 3;	   return; 
	}


	if(g_Gamepads[0].Event == XBGAMEPAD_B  && cheatMode == 5 && cheatDBMode == 6) { 
		if(DisableMenuSounds == 0) playEffect(1); writeCheatFile();
		cheatMode = -1;	   
		clearCheatCodeListTips();
		return; 
	}


	if((g_Gamepads[0].Event == XBGAMEPAD_B) && (cheatMode == 5) && (cheatDBMode == 7)) { 
		if(DisableMenuSounds == 0) playEffect(1); writeCheatFile();
		cheatDBMode = 6;	   return; 
	}

	//AR, GG, CC codes menu exit	
	if(g_Gamepads[0].Event == XBGAMEPAD_B  && cheatMode == 0) { 
		if(DisableMenuSounds == 0) playEffect(1); 
		cheatMode = -1; 
		cheatMenu = 0;
		return; 
	}

	if(g_Gamepads[0].Event == XBGAMEPAD_B  && cheatMode == -5) { //exit back to cheat type selection
		if(DisableMenuSounds == 0) playEffect(1); 
		cheatMode = 0; 
		cheatMenu = 0;
		return; 
	}

	//ar view no edit
	if(g_Gamepads[0].Event == XBGAMEPAD_B  && editCheat == 0 && cheatMode == 1) { 
		if(DisableMenuSounds == 0) 
			playEffect(1);
		cheatMode = 0;
		cheatMenu = 0;
	} 

	if(g_Gamepads[0].Event == XBGAMEPAD_B  && cheatMode == 20) { 
		if(DisableMenuSounds == 0) 
			playEffect(1);
		cheatMode = -5;
		cheatMenu = 0;
	} 

	if(g_Gamepads[0].Event == XBGAMEPAD_B  && cheatMode == 21) { 
		if(DisableMenuSounds == 0) 
			playEffect(1);
		cheatMode = -5;
		cheatMenu = 0;
	} 

	if(g_Gamepads[0].Event == XBGAMEPAD_B  && cheatMode == 22) { 
		if(DisableMenuSounds == 0) 
			playEffect(1);
		cheatMode = -5;
		cheatMenu = 0;
	} 
	//ar edit
	if(g_Gamepads[0].Event == XBGAMEPAD_B  && editCheat == 1 && cheatMode == 1) { 
		if(DisableMenuSounds == 0) playEffect(1);
		editCheat = 0;

		return;
	}

	//gg view no edit
	if(g_Gamepads[0].Event == XBGAMEPAD_B  && editCheat == 0 && cheatMode == 2) { 
		if(DisableMenuSounds == 0) playEffect(1);cheatMode = 0;   cheatMenu = 1;} 
	//g edit
	if(g_Gamepads[0].Event == XBGAMEPAD_B  && editCheat == 1 && cheatMode == 2) { 
		if(DisableMenuSounds == 0) playEffect(1);editCheat = 0;  return; } 


	//CS view no edit
	if(g_Gamepads[0].Event == XBGAMEPAD_B  && editCheat == 0 && cheatMode == 3) { 
		if(DisableMenuSounds == 0) playEffect(1);cheatMode = 0;  cheatMenu = 2; } 
	//CS edit
	if(g_Gamepads[0].Event == XBGAMEPAD_B  && editCheat == 1 && cheatMode == 3) { 
		if(DisableMenuSounds == 0) playEffect(1);editCheat = 0;  return; } 

	//if(g_Gamepads[0].Event == XBGAMEPAD_B  && cheatMode == 3) { if(DisableMenuSounds == 0) playEffect(1); cheatMode = 0;  } 



	if((cheatMode == 5 && cheatDBMode == 4) || (cheatMode == 5 && cheatDBMode == 1)  || (cheatMode == 5 && cheatDBMode == 6)) {
		if (g_Gamepads[0].fX1 < 0) {
			zLeftCD-=3; 
		} // Left
		if (g_Gamepads[0].fX1 > 0) {
			zLeftCD+=3; 
		}// Right
	}

	if( g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) {
		if(cheatMode == 5 && cheatDBMode == 0) {
			if(slow >= 1)  { 
				slow = 0;
				//if(DisableMenuSounds == 0 && cheatDBGameSelected != 0) 
				//	playEffect(0);
			}

			if(leftAnalog == 255)
				slow = scrollSpeed;
			else
				slow += ((float)leftAnalog/255.0f);
			//slow += (scrollSpeed / 10.0f);
			cheatDBGameSelected-=((int)slow); if(cheatDBGameSelected < 0) cheatDBGameSelected = 0;
		}

		if(cheatMode == 5 && cheatDBMode == 1) {
			if(slow >= 1)  { 
				slow = 0;
				//if(DisableMenuSounds == 0 && cheatDBGameSelected != 0) 
				//	playEffect(0);
			}

			if(leftAnalog == 255)
				slow = scrollSpeed;
			else
				slow += ((float)leftAnalog/255.0f);
			//slow += (scrollSpeed / 10.0f);
			cheatDBGameSelectedCheat-=((int)slow); if(cheatDBGameSelectedCheat < 0) cheatDBGameSelectedCheat = 0;
		}
		//AR
		if(cheatMode == 5 && cheatDBMode == 3) {
			if(slowAR >= 1)  { 
				slowAR = 0;
				//if(DisableMenuSounds == 0 && cheatDBGameSelected != 0) 
				//	playEffect(0);
			}

			if(leftAnalog == 255)
				slowAR = scrollSpeed;
			else
				slowAR += ((float)leftAnalog/255.0f);
			//slow += (scrollSpeed / 10.0f);
			cheatDBGameSelectedAR-=((int)slowAR); if(cheatDBGameSelectedAR < 0) cheatDBGameSelectedAR = 0;
		}

		if(cheatMode == 5 && cheatDBMode == 4) {
			if(slowAR >= 1)  { 
				slowAR = 0;
				//if(DisableMenuSounds == 0 && cheatDBGameSelected != 0) 
				//	playEffect(0);
			}

			if(leftAnalog == 255)
				slowAR = scrollSpeed;
			else
				slowAR += ((float)leftAnalog/255.0f);
			//slow += (scrollSpeed / 10.0f);
			cheatDBGameSelectedCheatAR-=((int)slowAR); if(cheatDBGameSelectedCheatAR < 0) cheatDBGameSelectedCheatAR = 0;
		}
	}

	//Tips
	if(cheatMode == 5 && cheatDBMode == 6) {
		if(slowTips >= 1)  { 
			slowTips = 0;
			//if(DisableMenuSounds == 0 && cheatDBGameSelected != 0) 
			//	playEffect(0);
		}

		if(leftAnalog == 255)
			slowTips = scrollSpeed;
		else
			slowTips += ((float)leftAnalog/255.0f);
		//slow += (scrollSpeed / 10.0f);
		cheatDBGameSelectedTips-=((int)slowTips); if(cheatDBGameSelectedTips < 0) cheatDBGameSelectedTips = 0;
	}

	if(cheatMode == 5 && cheatDBMode == 7) {
		if(slowTips >= 1)  { 
			slowTips = 0;
			//if(DisableMenuSounds == 0 && cheatDBGameSelected != 0) 
			//	playEffect(0);
		}

		if(leftAnalog == 255)
			slowTips = scrollSpeed;
		else
			slowTips += ((float)leftAnalog/255.0f);
		//slow += (scrollSpeed / 10.0f);
		cheatDBGameSelectedCheatTips-=((int)slowTips); if(cheatDBGameSelectedCheatTips < 0) cheatDBGameSelectedCheatTips = 0;
	}
	if(cheatMode == 5 && cheatDBMode == 2) {
		if(g_Gamepads[0].Event == XBGAMEPAD_B) { 
			if(DisableMenuSounds == 0) playEffect(1); 
			cheatDBMode = 1;
			//writeCheatFile();
			return; 
		}
		//=, <, <=, >, >=, !=
		if(g_Gamepads[0].Event == XBGAMEPAD_DPAD_UP) { 
			if(DisableMenuSounds == 0) playEffect(0);	cheatSearchMenu--; if(cheatSearchMenu < 0) cheatSearchMenu = 14;
		}
		if(g_Gamepads[0].Event == XBGAMEPAD_DPAD_DOWN) { 
			if(DisableMenuSounds == 0) playEffect(0);	cheatSearchMenu++; if(cheatSearchMenu > 14) cheatSearchMenu = 0;
		}
		if(g_Gamepads[0].Event == XBGAMEPAD_A) { 
			cheatDBMode = 1;
			//copy code to the selected slot.
			if(DisableMenuSounds == 0) playEffect(2);

			std::string code = codeDatabase[cheatDBGameSelected].codes[cheatDBGameSelectedCheat].code;
			int place = code.find_first_of(":", 0);
			std::string description = code.substr(place+2, (code.size()-(place+2)));
			int location = cheatSearchMenu;

			int offset = 0;
			for(int s = 0; s < 5; s++) {
				ggCodes[location][0] = getCheatCodeA(code[0+offset]); 
				ggCodes[location][1] = getCheatCodeA(code[1+offset]); 
				ggCodes[location][2] = getCheatCodeA(code[2+offset]); 
				ggCodes[location][3] = getCheatCodeA(code[3+offset]); 

				ggCodes[location][4] = getCheatCodeA(code[5+offset]); 
				ggCodes[location][5] = getCheatCodeA(code[6+offset]); 
				ggCodes[location][6] = getCheatCodeA(code[7+offset]); 
				ggCodes[location][7] = getCheatCodeA(code[8+offset]); 
				//On/Off: 
				ggCodes[location][8] = 1;//getCheatCodeB('0');//off 

				for(int s = 0; s < 27; s++) ggCodes[location][s+9] = 78; 

				for(int d = 0; d < 27; d++) { 
					if(description[d] == '\0' || description[d] == '\n') {
						break;
					}
					ggCodes[location][d+9] = getCheatCode(description[d]); 
				}

				//are there any more codes?
				if(code[9+offset] == '+') {
					location++;
					if(location > 14) location = 0;
					offset+=10;
				}
				else {
					break;
				}
				//9+0 = 9 (offset = 10)
				//9+10 = 19 (offset = 20)
			}
			writeCheatFile();
		}

		return;
	}

	//AR
	if(cheatMode == 5 && cheatDBMode == 5) {
		if(g_Gamepads[0].Event == XBGAMEPAD_B) { 
			if(DisableMenuSounds == 0) playEffect(1); 
			cheatDBMode = 4;
			//writeCheatFile();
			return; 
		}
		//=, <, <=, >, >=, !=
		if(g_Gamepads[0].Event == XBGAMEPAD_DPAD_UP) { 
			if(DisableMenuSounds == 0) playEffect(0);	cheatSearchMenu--; if(cheatSearchMenu < 0) cheatSearchMenu = 14;
		}
		if(g_Gamepads[0].Event == XBGAMEPAD_DPAD_DOWN) { 
			if(DisableMenuSounds == 0) playEffect(0);	cheatSearchMenu++; if(cheatSearchMenu > 14) cheatSearchMenu = 0;
		}
		if(g_Gamepads[0].Event == XBGAMEPAD_A) { 
			cheatDBMode = 4;
			//copy code to the selected slot.
			if(DisableMenuSounds == 0) playEffect(2);

			std::string code = codeDatabaseAR[cheatDBGameSelectedAR].codes[cheatDBGameSelectedCheatAR].code;
			int place = code.find_first_of(":", 0);
			std::string description = code.substr(place+2, (code.size()-(place+2)));

			int location = cheatSearchMenu;

			int offset = 0;
			for(int s = 0; s < 5; s++) {
				Codes[location][0] = getCheatCodeA(code[0+offset]); 
				Codes[location][1] = getCheatCodeA(code[1+offset]); 
				Codes[location][2] = getCheatCodeA(code[2+offset]); 
				Codes[location][3] = getCheatCodeA(code[3+offset]); 

				Codes[location][4] = getCheatCodeA(code[4+offset]); 
				Codes[location][5] = getCheatCodeA(code[5+offset]); 
				Codes[location][6] = getCheatCodeA(code[6+offset]); 
				Codes[location][7] = getCheatCodeA(code[7+offset]); 
				//On/Off: 
				Codes[location][8] = 1;//getCheatCodeB('0');//off 

				for(int s = 0; s < 27; s++)  Codes[location][s+9] = 78; 

				for(int d = 0; d < 27; d++) { 
					if(description[d] == '\0' || description[d] == '\n') {
						break;
					}
					Codes[location][d+9] = getCheatCode(description[d]); 
				}

				//are there any more codes?
				if(code[8+offset] == '+') {
					location++;
					if(location > 14) location = 0;
					offset+=10;
				}
				else {
					break;
				}
				//9+0 = 9 (offset = 10)
				//9+10 = 19 (offset = 20)
			}
			writeCheatFile();
		}

		return;
	}

	if( g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) {
		if(cheatMode == 5 && cheatDBMode == 0) {
			if(slow >= 1) { 
				slow = 0; 
			} 
			if(rightAnalog == 255)
				slow = scrollSpeed;
			else
				slow += ((float)rightAnalog/255.0f);
			cheatDBGameSelected+=((int)slow); if(cheatDBGameSelected >= codeDatabase.size()) cheatDBGameSelected = codeDatabase.size() - 1;
		}

		if(cheatMode == 5 && cheatDBMode == 1) {
			if(slow >= 1) { 
				slow = 0; 
			} 

			if(rightAnalog == 255)
				slow = scrollSpeed;
			else
				slow += ((float)rightAnalog/255.0f);
			cheatDBGameSelectedCheat+=((int)slow); if(cheatDBGameSelectedCheat >= codeDatabase[cheatDBGameSelected].codes.size()) cheatDBGameSelectedCheat = codeDatabase[cheatDBGameSelected].codes.size() - 1;
		}

		//AR
		if(cheatMode == 5 && cheatDBMode == 3) {
			if(slowAR >= 1) { 
				slowAR = 0; 
			} 

			if(rightAnalog == 255)
				slowAR = scrollSpeed;
			else
				slowAR += ((float)rightAnalog/255.0f);
			//slow += (scrollSpeed / 10.0f);
			cheatDBGameSelectedAR+=((int)slowAR); if(cheatDBGameSelectedAR >= codeDatabaseAR.size()) cheatDBGameSelectedAR = codeDatabaseAR.size() - 1;
		}

		if(cheatMode == 5 && cheatDBMode == 4) {
			if(slowAR >= 1) { 
				slowAR = 0; 
			} 

			if(rightAnalog == 255)
				slowAR = scrollSpeed;
			else
				slowAR += ((float)rightAnalog/255.0f);
			cheatDBGameSelectedCheatAR+=((int)slowAR); if(cheatDBGameSelectedCheatAR >= codeDatabaseAR[cheatDBGameSelectedAR].codes.size()) cheatDBGameSelectedCheatAR = codeDatabaseAR[cheatDBGameSelectedAR].codes.size() - 1;
		}
	}

	//Tips
	if(cheatMode == 5 && cheatDBMode == 6) {
		if(slowTips >= 1) { 
			slowTips = 0; 
		} 

		if(rightAnalog == 255)
			slowTips = scrollSpeed;
		else
			slowTips += ((float)rightAnalog/255.0f);
		cheatDBGameSelectedTips+=((int)slowTips); if(cheatDBGameSelectedTips >= codeDatabaseTips.size()) cheatDBGameSelectedTips = codeDatabaseTips.size() - 1;
	}

	if(cheatMode == 5 && cheatDBMode == 7) {
		if(slowTips >= 1) { 
			slowTips = 0; 
		} 

		if(rightAnalog == 255)
			slowTips = scrollSpeed;
		else
			slowTips += ((float)rightAnalog/255.0f);
		cheatDBGameSelectedCheatTips+=((int)slowTips); if(cheatDBGameSelectedCheatTips >= codeDatabaseTips[cheatDBGameSelectedTips].codes.size()) cheatDBGameSelectedCheatTips = codeDatabaseTips[cheatDBGameSelectedTips].codes.size() - 1;
	}

	if(g_Gamepads[0].Event == XBGAMEPAD_DPAD_UP) { 
		if(cheatMode == 1 || cheatMode == 2 || cheatMode == 3) {
			if(DisableMenuSounds == 0) playEffect(0);	row--; if(row < 0) row = 14;
		}

		if(cheatMode == 20 || cheatMode == 21 || cheatMode == 22) {
			if(DisableMenuSounds == 0) playEffect(0);	row--; if(row < 0) row = 14;
		}

		if(cheatMode == 0) {
			if(DisableMenuSounds == 0) playEffect(0);	cheatMenu--; if(cheatMenu < 0) cheatMenu = 3;
		}

		if(cheatMode == -5) {//pick cheat code type to edit description
			if(DisableMenuSounds == 0) playEffect(0);	cheatMenu--; if(cheatMenu < 0) cheatMenu = 2;
		}

		if(cheatMode == -1) {
			if(DisableMenuSounds == 0) playEffect(0);	cheatMenu--; if(cheatMenu < 0) cheatMenu = 4;
		}

		if(cheatMode == 5 && cheatDBMode == 0) {
			if(DisableMenuSounds == 0 && cheatDBGameSelected != 0) playEffect(0);
			cheatDBGameSelected--; if(cheatDBGameSelected < 0) cheatDBGameSelected = 0;

		}

		if(cheatMode == 5 && cheatDBMode == 1) {
			if(DisableMenuSounds == 0 && cheatDBGameSelectedCheat != 0) playEffect(0);
			cheatDBGameSelectedCheat--; if(cheatDBGameSelectedCheat < 0) cheatDBGameSelectedCheat = 0;

		}


		if(cheatMode == 5 && cheatDBMode == 3) {
			if(DisableMenuSounds == 0 && cheatDBGameSelectedAR != 0) playEffect(0);
			cheatDBGameSelectedAR--; if(cheatDBGameSelectedAR < 0) cheatDBGameSelectedAR = 0;

		}

		if(cheatMode == 5 && cheatDBMode == 4) {
			if(DisableMenuSounds == 0 && cheatDBGameSelectedCheatAR != 0) playEffect(0);
			cheatDBGameSelectedCheatAR--; if(cheatDBGameSelectedCheatAR < 0) cheatDBGameSelectedCheatAR = 0;

		}

		if(cheatMode == 5 && cheatDBMode == 6) {
			if(DisableMenuSounds == 0 && cheatDBGameSelectedTips != 0) playEffect(0);
			cheatDBGameSelectedTips--; if(cheatDBGameSelectedTips < 0) cheatDBGameSelectedTips = 0;

		}

		if(cheatMode == 5 && cheatDBMode == 7) {
			if(DisableMenuSounds == 0 && cheatDBGameSelectedCheatTips != 0) playEffect(0);
			cheatDBGameSelectedCheatTips--; if(cheatDBGameSelectedCheatTips < 0) cheatDBGameSelectedCheatTips = 0;

		}
	} 
	if(g_Gamepads[0].Event == XBGAMEPAD_DPAD_DOWN) { 
		if(cheatMode == 1 || cheatMode == 2 || cheatMode == 3) {
			if(DisableMenuSounds == 0) playEffect(0);	row++; if(row > 14) row = 0;
		}

		if(cheatMode == 20 || cheatMode == 21 || cheatMode == 22) {
			if(DisableMenuSounds == 0) playEffect(0);	row++; if(row > 14) row = 0;
		}

		if(cheatMode == 0) {
			if(DisableMenuSounds == 0) playEffect(0);	cheatMenu++; if(cheatMenu > 3) cheatMenu = 0;
		}

		if(cheatMode == -5) {
			if(DisableMenuSounds == 0) playEffect(0);	cheatMenu++; if(cheatMenu > 2) cheatMenu = 0;
		}

		if(cheatMode == -1) {
			if(DisableMenuSounds == 0) playEffect(0);	cheatMenu++; if(cheatMenu > 4) cheatMenu = 0;
		}

		if(cheatMode == 5 && cheatDBMode == 0) {
			if(DisableMenuSounds == 0 && (cheatDBGameSelected != (codeDatabase.size() - 1))) playEffect(0);	
			cheatDBGameSelected++; if(cheatDBGameSelected >= codeDatabase.size()) cheatDBGameSelected = codeDatabase.size() - 1;

		}
		//codeDatabase[cheatDBGameSelected].codes.size()

		if(cheatMode == 5 && cheatDBMode == 1) {
			if(DisableMenuSounds == 0 && (cheatDBGameSelectedCheat != (codeDatabase[cheatDBGameSelected].codes.size() - 1))) playEffect(0);	
			cheatDBGameSelectedCheat++; if(cheatDBGameSelectedCheat >=codeDatabase[cheatDBGameSelected].codes.size()) cheatDBGameSelectedCheat = codeDatabase[cheatDBGameSelected].codes.size()- 1;

		}

		//AR
		if(cheatMode == 5 && cheatDBMode == 3) {
			if(DisableMenuSounds == 0 && (cheatDBGameSelectedAR != (codeDatabaseAR.size() - 1))) playEffect(0);	
			cheatDBGameSelectedAR++; if(cheatDBGameSelectedAR >= codeDatabaseAR.size()) cheatDBGameSelectedAR = codeDatabaseAR.size() - 1;

		}
		//codeDatabase[cheatDBGameSelected].codes.size()

		if(cheatMode == 5 && cheatDBMode == 4) {
			if(DisableMenuSounds == 0 && (cheatDBGameSelectedCheatAR != (codeDatabaseAR[cheatDBGameSelectedAR].codes.size() - 1))) playEffect(0);	
			cheatDBGameSelectedCheatAR++; if(cheatDBGameSelectedCheatAR >=codeDatabaseAR[cheatDBGameSelectedAR].codes.size()) cheatDBGameSelectedCheatAR = codeDatabaseAR[cheatDBGameSelectedAR].codes.size()- 1;

		}

		//Tips
		if(cheatMode == 5 && cheatDBMode == 6) {
			if(DisableMenuSounds == 0 && (cheatDBGameSelectedTips != (codeDatabaseTips.size() - 1))) playEffect(0);	
			cheatDBGameSelectedTips++; if(cheatDBGameSelectedTips >= codeDatabaseTips.size()) cheatDBGameSelectedTips = codeDatabaseTips.size() - 1;
		}

		if(cheatMode == 5 && cheatDBMode == 7) {
			if(DisableMenuSounds == 0 && (cheatDBGameSelectedCheatTips != (codeDatabaseTips[cheatDBGameSelectedTips].codes.size() - 1))) playEffect(0);	
			cheatDBGameSelectedCheatTips++; if(cheatDBGameSelectedCheatTips >=codeDatabaseTips[cheatDBGameSelectedTips].codes.size()) cheatDBGameSelectedCheatTips = codeDatabaseTips[cheatDBGameSelectedTips].codes.size()- 1;
		}
	} 

	if(editCheat == 0 && (cheatMode == 1 || cheatMode == 2 || cheatMode == 3)) {


		if(cheatMode == 1) {
			if(g_Gamepads[0].Event == XBGAMEPAD_A) { 
				if(DisableMenuSounds == 0) playEffect(2);
				Codes[row][8] = (Codes[row][8] + 1) & 0x01; //Toggle on or off 
			}
			if(g_Gamepads[0].Event == XBGAMEPAD_Y) { 
				if(DisableMenuSounds == 0) playEffect(2);
				unsigned char u = (Codes[row][2] & 0x08) >> 3;

				if(u == 0) u = 1; else u = 0;
				Codes[row][2] = ((Codes[row][2] & 0xF7) | (u << 3)); //Fix 
			}
		}

		if(cheatMode == 2) {
			if(g_Gamepads[0].Event == XBGAMEPAD_A) { 

				if(DisableMenuSounds == 0) playEffect(2);
				ggCodes[row][8] = (ggCodes[row][8] + 1) & 0x01; //Toggle on or off 
			}
		}

		if(cheatMode == 3) {
			if(g_Gamepads[0].Event == XBGAMEPAD_A) { 

				if(DisableMenuSounds == 0) playEffect(2);
				csCodes[row][8] = (csCodes[row][8] + 1) & 0x01; //Toggle on or off 
			}
		}

		if(g_Gamepads[0].Event == XBGAMEPAD_X) { 
			if(DisableMenuSounds == 0) playEffect(2);
			editCheat = 1;
		}
		return;
	}

	if(g_Gamepads[0].Event == XBGAMEPAD_A && cheatMode == 20) { 
		if(DisableMenuSounds == 0) playEffect(2);

		//Show keyboard for AR and code selected
		kSlot = row;
		keyBoardDisplay = 0;
		initKeyboard();
		resetKeyBoard();

		keyBoardDraw = 1;
		return;
	}
	if(g_Gamepads[0].Event == XBGAMEPAD_A && cheatMode == 21) { 
		if(DisableMenuSounds == 0) playEffect(2);
		keyBoardDisplay = 0;
		kSlot = row;
		initKeyboard();
		resetKeyBoard();

		keyBoardDraw = 1;
		//Show keyboard for GG and code selected
		return;
	}
	if(g_Gamepads[0].Event == XBGAMEPAD_A && cheatMode == 22) { 
		if(DisableMenuSounds == 0) playEffect(2);
		keyBoardDisplay = 0;
		kSlot = row; 
		initKeyboard();
		resetKeyBoard();

		keyBoardDraw = 1;
		//Show keyboard for GG and code selected
		return;
	}

	if(cheatMode == 0) {
		if(g_Gamepads[0].Event == XBGAMEPAD_A) { 
			if(DisableMenuSounds == 0) playEffect(2);
			if(cheatMenu == 0) {
				cheatMode = 1;//draw list of AR
				cheatMenu = 0;
			}
			if(cheatMenu == 1) {//draw list of GG
				cheatMode = 2;
				cheatMenu = 0;
			}
			if(cheatMenu == 2) { //Cheat Search Codes 
				cheatMode = 3;
				cheatMenu = 0;
			}

			if(cheatMenu == 3) { //Cheat Search Codes 
				cheatMode = -5;
				cheatMenu = 0;
			}
		}
		return;
	}

	if(cheatMode == -5) {
		if(g_Gamepads[0].Event == XBGAMEPAD_A) { 
			if(DisableMenuSounds == 0) playEffect(2);
			if(cheatMenu == 0) {//PAR edit draw list of 15 slots
				cheatMode = 20;
				kType = 0;
				cheatMenu = 0;
			}
			if(cheatMenu == 1) {//GG edit draw list of 15 slots
				kType = 1;
				cheatMode = 21;
				cheatMenu = 0;
			}
			if(cheatMenu == 2) { //CS edit draw list of 15 slots
				kType = 2;
				cheatMode = 22;
				cheatMenu = 0;
			}
		}
		return;
	}

	if(g_Gamepads[0].Event == XBGAMEPAD_A && cheatMode == 5 && cheatDBMode == 0) {
		if(DisableMenuSounds == 0) playEffect(2);	
		cheatDBMode = 1;
		cheatDBGameSelectedCheat = 0;
		return;
	}

	if(g_Gamepads[0].Event == XBGAMEPAD_A && cheatMode == 5 && cheatDBMode == 1) {
		if(DisableMenuSounds == 0) playEffect(2);
		//start process of copying codes to a slot.
		cheatDBMode = 2;
		cheatSearchMenu = 0;
		return;
	}

	if(g_Gamepads[0].Event == XBGAMEPAD_A && cheatMode == 5 && cheatDBMode == 3) {
		if(DisableMenuSounds == 0) playEffect(2);	
		cheatDBMode = 4;
		cheatDBGameSelectedCheatAR = 0;
		return;
	}

	if(g_Gamepads[0].Event == XBGAMEPAD_A && cheatMode == 5 && cheatDBMode == 4) {
		if(DisableMenuSounds == 0) playEffect(2);
		//start process of copying codes to a slot.
		cheatDBMode = 5;
		cheatSearchMenu = 0;
		return;
	}

	if(g_Gamepads[0].Event == XBGAMEPAD_A && cheatMode == 5 && cheatDBMode == 6) {
		if(DisableMenuSounds == 0) playEffect(2);	
		cheatDBMode = 7;
		cheatDBGameSelectedCheatTips = 0;
		return;
	}

	if(cheatMode == -1) {
		if(g_Gamepads[0].Event == XBGAMEPAD_A) { 
			if(DisableMenuSounds == 0) playEffect(2);
			if(cheatMenu == 0) {
				cheatMode = 0;
			}
			if(cheatMenu == 1) { //cheatSeach
				cheatMode = 4;
				cheatSearchMode = 0;
				cheatSearchMenu = 0;
			}
			if(cheatMenu == 2) { //GG cheat Database

				buildCheatCodeList();
				cheatMode = 5;
				cheatDBMode = 0;

			}

			if(cheatMenu == 3) { //AR cheat Database
				cheatMode = 5;
				cheatDBMode = 3;
				buildCheatCodeListAR();

			}

			if(cheatMenu == 4) { //Tips cheat Database
				cheatMode = 5;
				cheatDBMode = 6;
				buildCheatCodeListTips();
			}

		}
		return;
	}

	if(g_Gamepads[0].Event == XBGAMEPAD_DPAD_LEFT  && editCheat == 1 && (cheatMode == 1 || cheatMode == 2 || cheatMode == 3)) { if(DisableMenuSounds == 0) playEffect(0);	col--; if(col < 0) col = 8+27; } 
	if(g_Gamepads[0].Event == XBGAMEPAD_DPAD_RIGHT  && editCheat == 1 && (cheatMode == 1 || cheatMode == 2 || cheatMode == 3)) { if(DisableMenuSounds == 0) playEffect(0);	col++; if(col > 8+27) col = 0; } 

	if(g_Gamepads[0].Event == XBGAMEPAD_A && editCheat == 1 && (cheatMode == 1 || cheatMode == 2 || cheatMode == 3)) { //Increase value 
		if(DisableMenuSounds == 0) playEffect(2);
		if(cheatMode == 1) {
			if(col != 8) { //One of the code digits is selected 
				if(col < 8) { 
					Codes[row][col] =  (Codes[row][col] + 1) & 0x0F; //Increase the value of this digit 
				} 
				else { 
					Codes[row][col] =  (Codes[row][col] + 1); 
					if(Codes[row][col] > 108) 
						Codes[row][col] = 16; 
				} 
			} 
			else { 
				Codes[row][col] = (Codes[row][col] + 1) & 0x01; //Toggle on or off 
			} 
		}
		if(cheatMode == 2) {
			if(col != 8) { //One of the code digits is selected 
				if(col < 8) { 
					ggCodes[row][col] =  (ggCodes[row][col] + 1) & 0x0F; //Increase the value of this digit 
				} 
				else { 
					ggCodes[row][col] =  (ggCodes[row][col] + 1); 
					if(ggCodes[row][col] > 108) 
						ggCodes[row][col] = 16; 
				} 
			} 
			else { 
				ggCodes[row][col] = (ggCodes[row][col] + 1) & 0x01; //Toggle on or off 
			} 
		}

		if(cheatMode == 3) {
			if(col != 8) { //One of the code digits is selected 
				if(col < 8) { 
					csCodes[row][col] =  (csCodes[row][col] + 1) & 0x0F; //Increase the value of this digit 
				} 
				else { 
					csCodes[row][col] =  (csCodes[row][col] + 1); 
					if(csCodes[row][col] > 108) 
						csCodes[row][col] = 16; 
				} 
			} 
			else { 
				csCodes[row][col] = (csCodes[row][col] + 1) & 0x01; //Toggle on or off 
			} 
		}
	} 

	if(g_Gamepads[0].Event == XBGAMEPAD_X  && editCheat == 1 && (cheatMode == 1 || cheatMode == 2 || cheatMode == 3)) { //decrease value 
		if(DisableMenuSounds == 0) playEffect(2);
		if(cheatMode == 1) {
			if(col != 8) { //One of the code digits is selected 
				if(col < 8) { 
					Codes[row][col] =  (Codes[row][col] - 1) & 0x0F; //Increase the value of this digit 
				} 
				else { 
					Codes[row][col] =  (Codes[row][col] - 1); 
					if(Codes[row][col] < 16) 
						Codes[row][col] = 108; 
				} 
			} 
			else { 
				Codes[row][col] = (Codes[row][col] - 1) & 0x01; //Toggle on or off 
			} 
		}

		if(cheatMode == 2) {
			if(col != 8) { //One of the code digits is selected 
				if(col < 8) { 
					ggCodes[row][col] =  (ggCodes[row][col] - 1) & 0x0F; //Increase the value of this digit 
				} 
				else { 
					ggCodes[row][col] =  (ggCodes[row][col] - 1); 
					if(ggCodes[row][col] < 16) 
						ggCodes[row][col] = 108; 
				} 
			} 
			else { 
				ggCodes[row][col] = (ggCodes[row][col] - 1) & 0x01; //Toggle on or off 
			} 
		}

		if(cheatMode == 3) {
			if(col != 8) { //One of the code digits is selected 
				if(col < 8) { 
					csCodes[row][col] =  (csCodes[row][col] - 1) & 0x0F; //Increase the value of this digit 
				} 
				else { 
					csCodes[row][col] =  (csCodes[row][col] - 1); 
					if(csCodes[row][col] < 16) 
						csCodes[row][col] = 108; 
				} 
			} 
			else { 
				csCodes[row][col] = (csCodes[row][col] - 1) & 0x01; //Tocsle on or off 
			} 
		}
	} 
} 


void drawCodeToggle(char * text, int r, int c) { 
	WCHAR t[5]; 
	if(text == "On") { 
		t[0] = text[0]; 
		t[1] = text[1]; 
		t[2] = '\0'; 
	} 
	else { 
		t[0] = text[0]; 
		t[1] = text[1]; 
		t[2] = text[2]; 
		t[3] = '\0'; 
	} 

	DWORD color = 0xffffff; //white if row not selected 
	if(cheatDrawn == row) { 
		color = 0xffff00; //yellow if row selected 
		if(r == row && c == col) 
			color = 0x00ff00; //geen for selected digit. 
	} 

	FontSetColour(color);
	FontText(t, leftXC, yC, 600); 
	leftXC += 50;
} 

void drawCode(char* text, int r, int c) { 
	WCHAR t[2]; 
	t[0] = text[0]; 
	t[1] = text[1]; 

	DWORD color = 0xffffff; //white if row not selected 
	if(cheatDrawn == row) { 
		color = 0xffff00; //yellow if row selected 
		if(r == row && c == col) 
			color = 0x00ff00; //geen for selected digit. 
	} 

	FontSetColour(color);
	FontText(t, leftXC, yC, 600); 
	leftXC += 12; 
} 

void drawCodeDash(char* text, int r, int c) { 
	WCHAR t[2]; 
	t[0] = text[0]; 
	t[1] = text[1]; 

	DWORD color = 0xffffff; //white if row not selected 
	if(cheatDrawn == row) { 
		color = 0xffff00; //yellow if row selected 
	} 

	FontSetColour(color);
	FontText(t, leftXC+3, yC, 600); 
	leftXC += 12; 
} 


void drawC(char* text) { 
	WCHAR t[20]; 
	for(int i = 0; i < 20; i++) { 
		if(text[i] == '\0') { 
			t[i] = text[i]; 
			break; 
		} 
		t[i] = text[i]; 
	} 
	DWORD color = 0xffffff; 
	if(cheatDrawn == row) color = 0xffff00; 

	FontSetColour(color);
	FontText(t, 50, yC, 600); 
} 




void drawNoEditCheat() {
	for(int r = 0; r < 15; r++) { 

		DWORD color = 0xffffff;
		if(r == row) color = 0xffff00;

		//on off
		leftXC = 237; 
		WCHAR toggle[4];
		if(Codes[r][8] == 0)  {
			toggle[0] = 'O';
			toggle[1] = 'f';
			toggle[2] = 'f';
			toggle[3] = '\0';

		}
		else {
			toggle[0] = 'O';
			toggle[1] = 'n';
			toggle[2] = '\0';
			toggle[3] = '\0';
			if(color == 0xffffff) {
				color = 0x00ff00;
			}
		}
		FontSetColour(color);
		FontText(toggle, leftXC, yC, 600); 


		//Draw the Code
		leftXC = 175-50;
		WCHAR code[9];
		for(int i = 0; i < 9; i++) code[i] = '\0';
		for(int c = 0; c < 8; c++) {
			if(Codes[r][c] == 0)  code[c] = '0'; 
			if(Codes[r][c] == 1)  code[c] = '1'; 
			if(Codes[r][c] == 2)  code[c] = '2'; 
			if(Codes[r][c] == 3)  code[c] = '3'; 
			if(Codes[r][c] == 4)  code[c] = '4'; 
			if(Codes[r][c] == 5)  code[c] = '5'; 
			if(Codes[r][c] == 6)  code[c] = '6'; 
			if(Codes[r][c] == 7)  code[c] = '7'; 
			if(Codes[r][c] == 8)  code[c] = '8'; 
			if(Codes[r][c] == 9)  code[c] = '9'; 
			if(Codes[r][c] == 10) code[c] = 'A'; 
			if(Codes[r][c] == 11) code[c] = 'B'; 
			if(Codes[r][c] == 12) code[c] = 'C'; 
			if(Codes[r][c] == 13) code[c] = 'D'; 
			if(Codes[r][c] == 14) code[c] = 'E'; 
			if(Codes[r][c] == 15) code[c] = 'F'; 
		}
		FontSetColour(color);
		FontText(code, leftXC, yC, 600); 



		//Draw description
		leftXC = 325-25;
		WCHAR codeD[28];
		for(int i = 0; i < 28; i++) codeD[i] = '\0';

		for(int c = 9; c < 9+27; c++) {
			if(Codes[r][c] == 16)  codeD[c-9] = 'A'; 
			if(Codes[r][c] == 17)  codeD[c-9] = 'B'; 
			if(Codes[r][c] == 18)  codeD[c-9] = 'C'; 
			if(Codes[r][c] == 19)  codeD[c-9] = 'D'; 
			if(Codes[r][c] == 20)  codeD[c-9] = 'E'; 
			if(Codes[r][c] == 21)  codeD[c-9] = 'F'; 
			if(Codes[r][c] == 22)  codeD[c-9] = 'G'; 
			if(Codes[r][c] == 23)  codeD[c-9] = 'H'; 
			if(Codes[r][c] == 24)  codeD[c-9] = 'I'; 
			if(Codes[r][c] == 25)  codeD[c-9] = 'J'; 
			if(Codes[r][c] == 26)  codeD[c-9] = 'K'; 
			if(Codes[r][c] == 27)  codeD[c-9] = 'L'; 
			if(Codes[r][c] == 28)  codeD[c-9] = 'M'; 
			if(Codes[r][c] == 29)  codeD[c-9] = 'N'; 
			if(Codes[r][c] == 30)  codeD[c-9] = 'O'; 
			if(Codes[r][c] == 31)  codeD[c-9] = 'P'; 
			if(Codes[r][c] == 32)  codeD[c-9] = 'Q'; 
			if(Codes[r][c] == 33)  codeD[c-9] = 'R'; 
			if(Codes[r][c] == 34)  codeD[c-9] = 'S'; 
			if(Codes[r][c] == 35)  codeD[c-9] = 'T'; 
			if(Codes[r][c] == 36)  codeD[c-9] = 'U'; 
			if(Codes[r][c] == 37)  codeD[c-9] = 'V'; 
			if(Codes[r][c] == 38)  codeD[c-9] = 'W'; 
			if(Codes[r][c] == 39)  codeD[c-9] = 'X'; 
			if(Codes[r][c] == 40)  codeD[c-9] = 'Y'; 
			if(Codes[r][c] == 41)  codeD[c-9] = 'Z'; 

			if(Codes[r][c] == 42)  codeD[c-9] = 'a'; 
			if(Codes[r][c] == 43)  codeD[c-9] = 'b'; 
			if(Codes[r][c] == 44)  codeD[c-9] = 'c'; 
			if(Codes[r][c] == 45)  codeD[c-9] = 'd'; 
			if(Codes[r][c] == 46)  codeD[c-9] = 'e'; 
			if(Codes[r][c] == 47)  codeD[c-9] = 'f'; 
			if(Codes[r][c] == 48)  codeD[c-9] = 'g'; 
			if(Codes[r][c] == 49)  codeD[c-9] = 'h'; 
			if(Codes[r][c] == 50)  codeD[c-9] = 'i'; 
			if(Codes[r][c] == 51)  codeD[c-9] = 'j'; 
			if(Codes[r][c] == 52)  codeD[c-9] = 'k'; 
			if(Codes[r][c] == 53)  codeD[c-9] = 'l'; 
			if(Codes[r][c] == 54)  codeD[c-9] = 'm'; 
			if(Codes[r][c] == 55)  codeD[c-9] = 'n'; 
			if(Codes[r][c] == 56)  codeD[c-9] = 'o'; 
			if(Codes[r][c] == 57)  codeD[c-9] = 'p'; 
			if(Codes[r][c] == 58)  codeD[c-9] = 'q'; 
			if(Codes[r][c] == 59)  codeD[c-9] = 'r'; 
			if(Codes[r][c] == 60)  codeD[c-9] = 's'; 
			if(Codes[r][c] == 61)  codeD[c-9] = 't'; 
			if(Codes[r][c] == 62)  codeD[c-9] = 'u'; 
			if(Codes[r][c] == 63)  codeD[c-9] = 'v'; 
			if(Codes[r][c] == 64)  codeD[c-9] = 'w'; 
			if(Codes[r][c] == 65)  codeD[c-9] = 'x'; 
			if(Codes[r][c] == 66)  codeD[c-9] = 'y'; 
			if(Codes[r][c] == 67)  codeD[c-9] = 'z'; 

			if(Codes[r][c] == 68)  codeD[c-9] = '0'; 
			if(Codes[r][c] == 69)  codeD[c-9] = '1'; 
			if(Codes[r][c] == 70)  codeD[c-9] = '2'; 
			if(Codes[r][c] == 71)  codeD[c-9] = '3'; 
			if(Codes[r][c] == 72)  codeD[c-9] = '4'; 
			if(Codes[r][c] == 73)  codeD[c-9] = '5'; 
			if(Codes[r][c] == 74)  codeD[c-9] = '6'; 
			if(Codes[r][c] == 75)  codeD[c-9] = '7'; 
			if(Codes[r][c] == 76)  codeD[c-9] = '8'; 
			if(Codes[r][c] == 77)  codeD[c-9] = '9'; 


			if(Codes[r][c] == 78)  codeD[c-9] = ' '; 
			if(Codes[r][c] == 79)  codeD[c-9] = '_'; 
			if(Codes[r][c] == 80)  codeD[c-9] = '('; 
			if(Codes[r][c] == 81)  codeD[c-9] = ')'; 
			if(Codes[r][c] == 82)  codeD[c-9] = '['; 
			if(Codes[r][c] == 83)  codeD[c-9] = ']'; 
			if(Codes[r][c] == 84)  codeD[c-9] = '{'; 
			if(Codes[r][c] == 85)  codeD[c-9] = '}'; 
			if(Codes[r][c] == 86)  codeD[c-9] = ','; 
			if(Codes[r][c] == 87)  codeD[c-9] = '\''; 
			if(Codes[r][c] == 88)  codeD[c-9] = '|'; 
			if(Codes[r][c] == 89)  codeD[c-9] = '+'; 
			if(Codes[r][c] == 90)  codeD[c-9] = '-'; 
			if(Codes[r][c] == 91)  codeD[c-9] = ':'; 
			if(Codes[r][c] == 92)  codeD[c-9] = '<'; 
			if(Codes[r][c] == 93)  codeD[c-9] = '>'; 
			if(Codes[r][c] == 94)  codeD[c-9] = '.'; 
			if(Codes[r][c] == 95)  codeD[c-9] = ';'; 
			if(Codes[r][c] == 96)  codeD[c-9] = '='; 
			if(Codes[r][c] == 97)  codeD[c-9] = '%'; 
			if(Codes[r][c] == 98)  codeD[c-9] = '~'; 
			if(Codes[r][c] == 99)  codeD[c-9] = '!'; 
			if(Codes[r][c] == 100)  codeD[c-9] = '@'; 
			if(Codes[r][c] == 101)  codeD[c-9] = '#'; 
			if(Codes[r][c] == 102)  codeD[c-9] = '$'; 
			if(Codes[r][c] == 103)  codeD[c-9] = '^'; 
			if(Codes[r][c] == 104)  codeD[c-9] = '&'; 
			if(Codes[r][c] == 105)  codeD[c-9] = '*'; 
			if(Codes[r][c] == 106)  codeD[c-9] = '`'; 
			if(Codes[r][c] == 107)  codeD[c-9] = '\\'; 
			if(Codes[r][c] == 108)  codeD[c-9] = '?'; 
		}
		FontSetColour(color);
		FontText(codeD, leftXC, yC, 600); 

		yC+= vSpace; 
		cheatDrawn++; 
	} 
}


void drawNoEditCheatCS() {
	for(int r = 0; r < 15; r++) { 

		DWORD color = 0xffffff;
		if(r == row) color = 0xffff00;

		//on off
		leftXC = 237; 
		WCHAR cstoggle[4];
		if(csCodes[r][8] == 0)  {
			cstoggle[0] = 'O';
			cstoggle[1] = 'f';
			cstoggle[2] = 'f';
			cstoggle[3] = '\0';

		}
		else {
			cstoggle[0] = 'O';
			cstoggle[1] = 'n';
			cstoggle[2] = '\0';
			cstoggle[3] = '\0';
			if(color == 0xffffff) {
				color = 0x00ff00;
			}
		}
		FontSetColour(color);
		FontText(cstoggle, leftXC, yC, 600); 


		//Draw the Code
		leftXC = 175-50;
		WCHAR code[9];
		for(int i = 0; i < 9; i++) code[i] = '\0';
		for(int c = 0; c < 8; c++) {
			if(csCodes[r][c] == 0)  code[c] = '0'; 
			if(csCodes[r][c] == 1)  code[c] = '1'; 
			if(csCodes[r][c] == 2)  code[c] = '2'; 
			if(csCodes[r][c] == 3)  code[c] = '3'; 
			if(csCodes[r][c] == 4)  code[c] = '4'; 
			if(csCodes[r][c] == 5)  code[c] = '5'; 
			if(csCodes[r][c] == 6)  code[c] = '6'; 
			if(csCodes[r][c] == 7)  code[c] = '7'; 
			if(csCodes[r][c] == 8)  code[c] = '8'; 
			if(csCodes[r][c] == 9)  code[c] = '9'; 
			if(csCodes[r][c] == 10) code[c] = 'A'; 
			if(csCodes[r][c] == 11) code[c] = 'B'; 
			if(csCodes[r][c] == 12) code[c] = 'C'; 
			if(csCodes[r][c] == 13) code[c] = 'D'; 
			if(csCodes[r][c] == 14) code[c] = 'E'; 
			if(csCodes[r][c] == 15) code[c] = 'F'; 
		}
		FontSetColour(color);
		FontText(code, leftXC, yC, 600); 
		//Draw description
		leftXC = 325-25;
		WCHAR codeD[28];
		for(int i = 0; i < 28; i++) codeD[i] = '\0';

		for(int c = 9; c < 9+27; c++) {
			if(csCodes[r][c] == 16)  codeD[c-9] = 'A'; 
			if(csCodes[r][c] == 17)  codeD[c-9] = 'B'; 
			if(csCodes[r][c] == 18)  codeD[c-9] = 'C'; 
			if(csCodes[r][c] == 19)  codeD[c-9] = 'D'; 
			if(csCodes[r][c] == 20)  codeD[c-9] = 'E'; 
			if(csCodes[r][c] == 21)  codeD[c-9] = 'F'; 
			if(csCodes[r][c] == 22)  codeD[c-9] = 'G'; 
			if(csCodes[r][c] == 23)  codeD[c-9] = 'H'; 
			if(csCodes[r][c] == 24)  codeD[c-9] = 'I'; 
			if(csCodes[r][c] == 25)  codeD[c-9] = 'J'; 
			if(csCodes[r][c] == 26)  codeD[c-9] = 'K'; 
			if(csCodes[r][c] == 27)  codeD[c-9] = 'L'; 
			if(csCodes[r][c] == 28)  codeD[c-9] = 'M'; 
			if(csCodes[r][c] == 29)  codeD[c-9] = 'N'; 
			if(csCodes[r][c] == 30)  codeD[c-9] = 'O'; 
			if(csCodes[r][c] == 31)  codeD[c-9] = 'P'; 
			if(csCodes[r][c] == 32)  codeD[c-9] = 'Q'; 
			if(csCodes[r][c] == 33)  codeD[c-9] = 'R'; 
			if(csCodes[r][c] == 34)  codeD[c-9] = 'S'; 
			if(csCodes[r][c] == 35)  codeD[c-9] = 'T'; 
			if(csCodes[r][c] == 36)  codeD[c-9] = 'U'; 
			if(csCodes[r][c] == 37)  codeD[c-9] = 'V'; 
			if(csCodes[r][c] == 38)  codeD[c-9] = 'W'; 
			if(csCodes[r][c] == 39)  codeD[c-9] = 'X'; 
			if(csCodes[r][c] == 40)  codeD[c-9] = 'Y'; 
			if(csCodes[r][c] == 41)  codeD[c-9] = 'Z'; 

			if(csCodes[r][c] == 42)  codeD[c-9] = 'a'; 
			if(csCodes[r][c] == 43)  codeD[c-9] = 'b'; 
			if(csCodes[r][c] == 44)  codeD[c-9] = 'c'; 
			if(csCodes[r][c] == 45)  codeD[c-9] = 'd'; 
			if(csCodes[r][c] == 46)  codeD[c-9] = 'e'; 
			if(csCodes[r][c] == 47)  codeD[c-9] = 'f'; 
			if(csCodes[r][c] == 48)  codeD[c-9] = 'g'; 
			if(csCodes[r][c] == 49)  codeD[c-9] = 'h'; 
			if(csCodes[r][c] == 50)  codeD[c-9] = 'i'; 
			if(csCodes[r][c] == 51)  codeD[c-9] = 'j'; 
			if(csCodes[r][c] == 52)  codeD[c-9] = 'k'; 
			if(csCodes[r][c] == 53)  codeD[c-9] = 'l'; 
			if(csCodes[r][c] == 54)  codeD[c-9] = 'm'; 
			if(csCodes[r][c] == 55)  codeD[c-9] = 'n'; 
			if(csCodes[r][c] == 56)  codeD[c-9] = 'o'; 
			if(csCodes[r][c] == 57)  codeD[c-9] = 'p'; 
			if(csCodes[r][c] == 58)  codeD[c-9] = 'q'; 
			if(csCodes[r][c] == 59)  codeD[c-9] = 'r'; 
			if(csCodes[r][c] == 60)  codeD[c-9] = 's'; 
			if(csCodes[r][c] == 61)  codeD[c-9] = 't'; 
			if(csCodes[r][c] == 62)  codeD[c-9] = 'u'; 
			if(csCodes[r][c] == 63)  codeD[c-9] = 'v'; 
			if(csCodes[r][c] == 64)  codeD[c-9] = 'w'; 
			if(csCodes[r][c] == 65)  codeD[c-9] = 'x'; 
			if(csCodes[r][c] == 66)  codeD[c-9] = 'y'; 
			if(csCodes[r][c] == 67)  codeD[c-9] = 'z'; 

			if(csCodes[r][c] == 68)  codeD[c-9] = '0'; 
			if(csCodes[r][c] == 69)  codeD[c-9] = '1'; 
			if(csCodes[r][c] == 70)  codeD[c-9] = '2'; 
			if(csCodes[r][c] == 71)  codeD[c-9] = '3'; 
			if(csCodes[r][c] == 72)  codeD[c-9] = '4'; 
			if(csCodes[r][c] == 73)  codeD[c-9] = '5'; 
			if(csCodes[r][c] == 74)  codeD[c-9] = '6'; 
			if(csCodes[r][c] == 75)  codeD[c-9] = '7'; 
			if(csCodes[r][c] == 76)  codeD[c-9] = '8'; 
			if(csCodes[r][c] == 77)  codeD[c-9] = '9'; 


			if(csCodes[r][c] == 78)  codeD[c-9] = ' '; 
			if(csCodes[r][c] == 79)  codeD[c-9] = '_'; 
			if(csCodes[r][c] == 80)  codeD[c-9] = '('; 
			if(csCodes[r][c] == 81)  codeD[c-9] = ')'; 
			if(csCodes[r][c] == 82)  codeD[c-9] = '['; 
			if(csCodes[r][c] == 83)  codeD[c-9] = ']'; 
			if(csCodes[r][c] == 84)  codeD[c-9] = '{'; 
			if(csCodes[r][c] == 85)  codeD[c-9] = '}'; 
			if(csCodes[r][c] == 86)  codeD[c-9] = ','; 
			if(csCodes[r][c] == 87)  codeD[c-9] = '\''; 
			if(csCodes[r][c] == 88)  codeD[c-9] = '|'; 
			if(csCodes[r][c] == 89)  codeD[c-9] = '+'; 
			if(csCodes[r][c] == 90)  codeD[c-9] = '-'; 
			if(csCodes[r][c] == 91)  codeD[c-9] = ':'; 
			if(csCodes[r][c] == 92)  codeD[c-9] = '<'; 
			if(csCodes[r][c] == 93)  codeD[c-9] = '>'; 
			if(csCodes[r][c] == 94)  codeD[c-9] = '.'; 
			if(csCodes[r][c] == 95)  codeD[c-9] = ';'; 
			if(csCodes[r][c] == 96)  codeD[c-9] = '='; 
			if(csCodes[r][c] == 97)  codeD[c-9] = '%'; 
			if(csCodes[r][c] == 98)  codeD[c-9] = '~'; 
			if(csCodes[r][c] == 99)  codeD[c-9] = '!'; 
			if(csCodes[r][c] == 100)  codeD[c-9] = '@'; 
			if(csCodes[r][c] == 101)  codeD[c-9] = '#'; 
			if(csCodes[r][c] == 102)  codeD[c-9] = '$'; 
			if(csCodes[r][c] == 103)  codeD[c-9] = '^'; 
			if(csCodes[r][c] == 104)  codeD[c-9] = '&'; 
			if(csCodes[r][c] == 105)  codeD[c-9] = '*'; 
			if(csCodes[r][c] == 106)  codeD[c-9] = '`'; 
			if(csCodes[r][c] == 107)  codeD[c-9] = '\\'; 
			if(csCodes[r][c] == 108)  codeD[c-9] = '?'; 
		}
		FontSetColour(color);
		FontText(codeD, leftXC, yC, 600); 

		yC+= vSpace; 
		cheatDrawn++; 
	} 
}

void drawOneByteCode(char* text, int c) { 
	WCHAR t[2]; 
	t[0] = text[0]; 
	t[1] = text[1]; 

	DWORD color = 0xffffff; //white if row not selected 

	color = 0xffff00; //yellow if row selected 
	if(c == oneByteCol) 
		color = 0x00ff00; //geen for selected digit. 
	FontSetColour(color);
	FontText(t, leftXC+zLeftCC, 150+zTopCC, sWidth); 
	leftXC += 12; 
} 

void oneByteDraw() {
	leftXC = (640 / 2) - 15;//616, 628, 640
	for(int c = 0; c < 3; c++) { 
		if(OneByte[c] == 0)  drawOneByteCode("0", c); 
		if(OneByte[c] == 1)  drawOneByteCode("1", c); 
		if(OneByte[c] == 2)  drawOneByteCode("2", c); 
		if(OneByte[c] == 3)  drawOneByteCode("3", c); 
		if(OneByte[c] == 4)  drawOneByteCode("4", c); 
		if(OneByte[c] == 5)  drawOneByteCode("5", c); 
		if(OneByte[c] == 6)  drawOneByteCode("6", c); 
		if(OneByte[c] == 7)  drawOneByteCode("7", c); 
		if(OneByte[c] == 8)  drawOneByteCode("8", c); 
		if(OneByte[c] == 9)  drawOneByteCode("9", c); 
	} 
}

void drawTwoByteCode(char* text, int c) { 
	WCHAR t[2]; 
	t[0] = text[0]; 
	t[1] = text[1]; 

	DWORD color = 0xffffff; //white if row not selected 

	color = 0xffff00; //yellow if row selected 
	if(c == twoByteCol) 
		color = 0x00ff00; //geen for selected digit. 

	FontSetColour(color);
	FontText(t, leftXC, 150, 600); 
	leftXC += 12; 
} 

void twoByteDraw() {
	leftXC = (640 / 2) - 36;
	for(int c = 0; c < 5; c++) { 
		if(TwoByte[c] == 0)  drawTwoByteCode("0", c); 
		if(TwoByte[c] == 1)  drawTwoByteCode("1", c); 
		if(TwoByte[c] == 2)  drawTwoByteCode("2", c); 
		if(TwoByte[c] == 3)  drawTwoByteCode("3", c); 
		if(TwoByte[c] == 4)  drawTwoByteCode("4", c); 
		if(TwoByte[c] == 5)  drawTwoByteCode("5", c); 
		if(TwoByte[c] == 6)  drawTwoByteCode("6", c); 
		if(TwoByte[c] == 7)  drawTwoByteCode("7", c); 
		if(TwoByte[c] == 8)  drawTwoByteCode("8", c); 
		if(TwoByte[c] == 9)  drawTwoByteCode("9", c); 
	} 
}


void proDraw() {
	if(editCheat == 0) {
		drawNoEditCheat();
		return;
	}

	for(int r = 0; r < 15; r++) { 
		leftXC = 75;
		for(int c = 0; c < 9+27; c++) { 
			if(c == 8) { 
				leftXC = 200; 
				if(Codes[r][c] == 0) drawCodeToggle("0ff", r, c); else drawCodeToggle("On", r, c); 
			} 
			else { 
				if(c < 9) { 
					if(Codes[r][c] == 0)  drawCode("0", r, c); 
					if(Codes[r][c] == 1)  drawCode("1", r, c); 
					if(Codes[r][c] == 2)  drawCode("2", r, c); 
					if(Codes[r][c] == 3)  drawCode("3", r, c); 
					if(Codes[r][c] == 4)  drawCode("4", r, c); 
					if(Codes[r][c] == 5)  drawCode("5", r, c); 
					if(Codes[r][c] == 6)  drawCode("6", r, c); 
					if(Codes[r][c] == 7)  drawCode("7", r, c); 
					if(Codes[r][c] == 8)  drawCode("8", r, c); 
					if(Codes[r][c] == 9)  drawCode("9", r, c); 
					if(Codes[r][c] == 10) drawCode("A", r, c); 
					if(Codes[r][c] == 11) drawCode("B", r, c); 
					if(Codes[r][c] == 12) drawCode("C", r, c); 
					if(Codes[r][c] == 13) drawCode("D", r, c); 
					if(Codes[r][c] == 14) drawCode("E", r, c); 
					if(Codes[r][c] == 15) drawCode("F", r, c); 
				} 
				else { 
					//Description
					if(Codes[r][c] == 16)  drawCode("A", r, c); 
					if(Codes[r][c] == 17)  drawCode("B", r, c); 
					if(Codes[r][c] == 18)  drawCode("C", r, c); 
					if(Codes[r][c] == 19)  drawCode("D", r, c); 
					if(Codes[r][c] == 20)  drawCode("E", r, c); 
					if(Codes[r][c] == 21)  drawCode("F", r, c); 
					if(Codes[r][c] == 22)  drawCode("G", r, c); 
					if(Codes[r][c] == 23)  drawCode("H", r, c); 
					if(Codes[r][c] == 24)  drawCode("I", r, c); 
					if(Codes[r][c] == 25)  drawCode("J", r, c); 
					if(Codes[r][c] == 26)  drawCode("K", r, c); 
					if(Codes[r][c] == 27)  drawCode("L", r, c); 
					if(Codes[r][c] == 28)  drawCode("M", r, c); 
					if(Codes[r][c] == 29)  drawCode("N", r, c); 
					if(Codes[r][c] == 30)  drawCode("O", r, c); 
					if(Codes[r][c] == 31)  drawCode("P", r, c); 
					if(Codes[r][c] == 32)  drawCode("Q", r, c); 
					if(Codes[r][c] == 33)  drawCode("R", r, c); 
					if(Codes[r][c] == 34)  drawCode("S", r, c); 
					if(Codes[r][c] == 35)  drawCode("T", r, c); 
					if(Codes[r][c] == 36)  drawCode("U", r, c); 
					if(Codes[r][c] == 37)  drawCode("V", r, c); 
					if(Codes[r][c] == 38)  drawCode("W", r, c); 
					if(Codes[r][c] == 39)  drawCode("X", r, c); 
					if(Codes[r][c] == 40)  drawCode("Y", r, c); 
					if(Codes[r][c] == 41)  drawCode("Z", r, c); 

					if(Codes[r][c] == 42)  drawCode("a", r, c); 
					if(Codes[r][c] == 43)  drawCode("b", r, c); 
					if(Codes[r][c] == 44)  drawCode("c", r, c); 
					if(Codes[r][c] == 45)  drawCode("d", r, c); 
					if(Codes[r][c] == 46)  drawCode("e", r, c); 
					if(Codes[r][c] == 47)  drawCode("f", r, c); 
					if(Codes[r][c] == 48)  drawCode("g", r, c); 
					if(Codes[r][c] == 49)  drawCode("h", r, c); 
					if(Codes[r][c] == 50)  drawCode("i", r, c); 
					if(Codes[r][c] == 51)  drawCode("j", r, c); 
					if(Codes[r][c] == 52)  drawCode("k", r, c); 
					if(Codes[r][c] == 53)  drawCode("l", r, c); 
					if(Codes[r][c] == 54)  drawCode("m", r, c); 
					if(Codes[r][c] == 55)  drawCode("n", r, c); 
					if(Codes[r][c] == 56)  drawCode("o", r, c); 
					if(Codes[r][c] == 57)  drawCode("p", r, c); 
					if(Codes[r][c] == 58)  drawCode("q", r, c); 
					if(Codes[r][c] == 59)  drawCode("r", r, c); 
					if(Codes[r][c] == 60)  drawCode("s", r, c); 
					if(Codes[r][c] == 61)  drawCode("t", r, c); 
					if(Codes[r][c] == 62)  drawCode("u", r, c); 
					if(Codes[r][c] == 63)  drawCode("v", r, c); 
					if(Codes[r][c] == 64)  drawCode("w", r, c); 
					if(Codes[r][c] == 65)  drawCode("x", r, c); 
					if(Codes[r][c] == 66)  drawCode("y", r, c); 
					if(Codes[r][c] == 67)  drawCode("z", r, c); 

					if(Codes[r][c] == 68)  drawCode("0", r, c); 
					if(Codes[r][c] == 69)  drawCode("1", r, c); 
					if(Codes[r][c] == 70)  drawCode("2", r, c); 
					if(Codes[r][c] == 71)  drawCode("3", r, c); 
					if(Codes[r][c] == 72)  drawCode("4", r, c); 
					if(Codes[r][c] == 73)  drawCode("5", r, c); 
					if(Codes[r][c] == 74)  drawCode("6", r, c); 
					if(Codes[r][c] == 75)  drawCode("7", r, c); 
					if(Codes[r][c] == 76)  drawCode("8", r, c); 
					if(Codes[r][c] == 77)  drawCode("9", r, c); 


					if(Codes[r][c] == 78)  drawCode(" ", r, c); 
					if(Codes[r][c] == 79)  drawCode("_", r, c); 
					if(Codes[r][c] == 80)  drawCode("(", r, c); 
					if(Codes[r][c] == 81)  drawCode(")", r, c); 
					if(Codes[r][c] == 82)  drawCode("[", r, c); 
					if(Codes[r][c] == 83)  drawCode("]", r, c); 
					if(Codes[r][c] == 84)  drawCode("{", r, c); 
					if(Codes[r][c] == 85)  drawCode("}", r, c); 
					if(Codes[r][c] == 86)  drawCode(",", r, c); 
					if(Codes[r][c] == 87)  drawCode("\'", r, c); 
					if(Codes[r][c] == 88)  drawCode("|", r, c); 
					if(Codes[r][c] == 89)  drawCode("+", r, c); 
					if(Codes[r][c] == 90)  drawCode("-", r, c); 
					if(Codes[r][c] == 91)  drawCode(":", r, c); 
					if(Codes[r][c] == 92)  drawCode("<", r, c); 
					if(Codes[r][c] == 93)  drawCode(">", r, c); 
					if(Codes[r][c] == 94)  drawCode(".", r, c); 
					if(Codes[r][c] == 95)  drawCode(";", r, c); 
					if(Codes[r][c] == 96)  drawCode("=", r, c); 
					if(Codes[r][c] == 97)  drawCode("%", r, c); 
					if(Codes[r][c] == 98)  drawCode("~", r, c); 
					if(Codes[r][c] == 99)  drawCode("!", r, c); 
					if(Codes[r][c] == 100)  drawCode("@", r, c); 
					if(Codes[r][c] == 101)  drawCode("#", r, c); 
					if(Codes[r][c] == 102)  drawCode("$", r, c); 
					if(Codes[r][c] == 103)  drawCode("^", r, c); 
					if(Codes[r][c] == 104)  drawCode("&", r, c); 
					if(Codes[r][c] == 105)  drawCode("*", r, c); 
					if(Codes[r][c] == 106)  drawCode("`", r, c); 
					if(Codes[r][c] == 107)  drawCode("\\", r, c); 
					if(Codes[r][c] == 108)  drawCode("?", r, c); 


				} 
			} 
		} 
		yC+= vSpace; 
		cheatDrawn++; 
	} 
}


void csDraw() {
	if(editCheat == 0) {
		drawNoEditCheatCS();
		return;
	}
	for(int r = 0; r < 15; r++) { 
		leftXC = 75;
		for(int c = 0; c < 9+27; c++) { 
			if(c == 8) { 
				leftXC = 200; 
				if(csCodes[r][c] == 0) drawCodeToggle("0ff", r, c); else drawCodeToggle("On", r, c); 
			} 
			else { 
				if(c < 9) { 
					if(csCodes[r][c] == 0)  drawCode("0", r, c); 
					if(csCodes[r][c] == 1)  drawCode("1", r, c); 
					if(csCodes[r][c] == 2)  drawCode("2", r, c); 
					if(csCodes[r][c] == 3)  drawCode("3", r, c); 
					if(csCodes[r][c] == 4)  drawCode("4", r, c); 
					if(csCodes[r][c] == 5)  drawCode("5", r, c); 
					if(csCodes[r][c] == 6)  drawCode("6", r, c); 
					if(csCodes[r][c] == 7)  drawCode("7", r, c); 
					if(csCodes[r][c] == 8)  drawCode("8", r, c); 
					if(csCodes[r][c] == 9)  drawCode("9", r, c); 
					if(csCodes[r][c] == 10) drawCode("A", r, c); 
					if(csCodes[r][c] == 11) drawCode("B", r, c); 
					if(csCodes[r][c] == 12) drawCode("C", r, c); 
					if(csCodes[r][c] == 13) drawCode("D", r, c); 
					if(csCodes[r][c] == 14) drawCode("E", r, c); 
					if(csCodes[r][c] == 15) drawCode("F", r, c); 
				} 
				else { 
					//Description
					if(csCodes[r][c] == 16)  drawCode("A", r, c); 
					if(csCodes[r][c] == 17)  drawCode("B", r, c); 
					if(csCodes[r][c] == 18)  drawCode("C", r, c); 
					if(csCodes[r][c] == 19)  drawCode("D", r, c); 
					if(csCodes[r][c] == 20)  drawCode("E", r, c); 
					if(csCodes[r][c] == 21)  drawCode("F", r, c); 
					if(csCodes[r][c] == 22)  drawCode("G", r, c); 
					if(csCodes[r][c] == 23)  drawCode("H", r, c); 
					if(csCodes[r][c] == 24)  drawCode("I", r, c); 
					if(csCodes[r][c] == 25)  drawCode("J", r, c); 
					if(csCodes[r][c] == 26)  drawCode("K", r, c); 
					if(csCodes[r][c] == 27)  drawCode("L", r, c); 
					if(csCodes[r][c] == 28)  drawCode("M", r, c); 
					if(csCodes[r][c] == 29)  drawCode("N", r, c); 
					if(csCodes[r][c] == 30)  drawCode("O", r, c); 
					if(csCodes[r][c] == 31)  drawCode("P", r, c); 
					if(csCodes[r][c] == 32)  drawCode("Q", r, c); 
					if(csCodes[r][c] == 33)  drawCode("R", r, c); 
					if(csCodes[r][c] == 34)  drawCode("S", r, c); 
					if(csCodes[r][c] == 35)  drawCode("T", r, c); 
					if(csCodes[r][c] == 36)  drawCode("U", r, c); 
					if(csCodes[r][c] == 37)  drawCode("V", r, c); 
					if(csCodes[r][c] == 38)  drawCode("W", r, c); 
					if(csCodes[r][c] == 39)  drawCode("X", r, c); 
					if(csCodes[r][c] == 40)  drawCode("Y", r, c); 
					if(csCodes[r][c] == 41)  drawCode("Z", r, c); 

					if(csCodes[r][c] == 42)  drawCode("a", r, c); 
					if(csCodes[r][c] == 43)  drawCode("b", r, c); 
					if(csCodes[r][c] == 44)  drawCode("c", r, c); 
					if(csCodes[r][c] == 45)  drawCode("d", r, c); 
					if(csCodes[r][c] == 46)  drawCode("e", r, c); 
					if(csCodes[r][c] == 47)  drawCode("f", r, c); 
					if(csCodes[r][c] == 48)  drawCode("g", r, c); 
					if(csCodes[r][c] == 49)  drawCode("h", r, c); 
					if(csCodes[r][c] == 50)  drawCode("i", r, c); 
					if(csCodes[r][c] == 51)  drawCode("j", r, c); 
					if(csCodes[r][c] == 52)  drawCode("k", r, c); 
					if(csCodes[r][c] == 53)  drawCode("l", r, c); 
					if(csCodes[r][c] == 54)  drawCode("m", r, c); 
					if(csCodes[r][c] == 55)  drawCode("n", r, c); 
					if(csCodes[r][c] == 56)  drawCode("o", r, c); 
					if(csCodes[r][c] == 57)  drawCode("p", r, c); 
					if(csCodes[r][c] == 58)  drawCode("q", r, c); 
					if(csCodes[r][c] == 59)  drawCode("r", r, c); 
					if(csCodes[r][c] == 60)  drawCode("s", r, c); 
					if(csCodes[r][c] == 61)  drawCode("t", r, c); 
					if(csCodes[r][c] == 62)  drawCode("u", r, c); 
					if(csCodes[r][c] == 63)  drawCode("v", r, c); 
					if(csCodes[r][c] == 64)  drawCode("w", r, c); 
					if(csCodes[r][c] == 65)  drawCode("x", r, c); 
					if(csCodes[r][c] == 66)  drawCode("y", r, c); 
					if(csCodes[r][c] == 67)  drawCode("z", r, c); 

					if(csCodes[r][c] == 68)  drawCode("0", r, c); 
					if(csCodes[r][c] == 69)  drawCode("1", r, c); 
					if(csCodes[r][c] == 70)  drawCode("2", r, c); 
					if(csCodes[r][c] == 71)  drawCode("3", r, c); 
					if(csCodes[r][c] == 72)  drawCode("4", r, c); 
					if(csCodes[r][c] == 73)  drawCode("5", r, c); 
					if(csCodes[r][c] == 74)  drawCode("6", r, c); 
					if(csCodes[r][c] == 75)  drawCode("7", r, c); 
					if(csCodes[r][c] == 76)  drawCode("8", r, c); 
					if(csCodes[r][c] == 77)  drawCode("9", r, c); 


					if(csCodes[r][c] == 78)  drawCode(" ", r, c); 
					if(csCodes[r][c] == 79)  drawCode("_", r, c); 
					if(csCodes[r][c] == 80)  drawCode("(", r, c); 
					if(csCodes[r][c] == 81)  drawCode(")", r, c); 
					if(csCodes[r][c] == 82)  drawCode("[", r, c); 
					if(csCodes[r][c] == 83)  drawCode("]", r, c); 
					if(csCodes[r][c] == 84)  drawCode("{", r, c); 
					if(csCodes[r][c] == 85)  drawCode("}", r, c); 
					if(csCodes[r][c] == 86)  drawCode(",", r, c); 
					if(csCodes[r][c] == 87)  drawCode("\'", r, c); 
					if(csCodes[r][c] == 88)  drawCode("|", r, c); 
					if(csCodes[r][c] == 89)  drawCode("+", r, c); 
					if(csCodes[r][c] == 90)  drawCode("-", r, c); 
					if(csCodes[r][c] == 91)  drawCode(":", r, c); 
					if(csCodes[r][c] == 92)  drawCode("<", r, c); 
					if(csCodes[r][c] == 93)  drawCode(">", r, c); 
					if(csCodes[r][c] == 94)  drawCode(".", r, c); 
					if(csCodes[r][c] == 95)  drawCode(";", r, c); 
					if(csCodes[r][c] == 96)  drawCode("=", r, c); 
					if(csCodes[r][c] == 97)  drawCode("%", r, c); 
					if(csCodes[r][c] == 98)  drawCode("~", r, c); 
					if(csCodes[r][c] == 99)  drawCode("!", r, c); 
					if(csCodes[r][c] == 100)  drawCode("@", r, c); 
					if(csCodes[r][c] == 101)  drawCode("#", r, c); 
					if(csCodes[r][c] == 102)  drawCode("$", r, c); 
					if(csCodes[r][c] == 103)  drawCode("^", r, c); 
					if(csCodes[r][c] == 104)  drawCode("&", r, c); 
					if(csCodes[r][c] == 105)  drawCode("*", r, c); 
					if(csCodes[r][c] == 106)  drawCode("`", r, c); 
					if(csCodes[r][c] == 107)  drawCode("\\", r, c); 
					if(csCodes[r][c] == 108)  drawCode("?", r, c); 
				} 
			} 
		} 
		yC+= vSpace; 
		cheatDrawn++; 
	} 
}


void drawNoEditCheatGG() {
	for(int r = 0; r < 15; r++) { 

		DWORD color = 0xffffff;
		if(r == row) color = 0xffff00;

		//on off
		leftXC = 237; 
		WCHAR toggle[4];
		if(ggCodes[r][8] == 0)  {
			toggle[0] = 'O';
			toggle[1] = 'f';
			toggle[2] = 'f';
			toggle[3] = '\0';

		}
		else {
			toggle[0] = 'O';
			toggle[1] = 'n';
			toggle[2] = '\0';
			toggle[3] = '\0';
			if(color == 0xffffff) {
				color = 0x00ff00;
			}
		}
		FontSetColour(color);
		FontText(toggle, leftXC, yC, 600); 


		//Draw the Code
		leftXC = 175-50;
		WCHAR code[10];
		for(int i = 0; i < 10; i++) code[i] = '\0';
		for(int c = 0; c < 4; c++) {
			if(ggCodes[r][c] == 0)  code[c] = '0'; 
			if(ggCodes[r][c] == 1)  code[c] = '1'; 
			if(ggCodes[r][c] == 2)  code[c] = '2'; 
			if(ggCodes[r][c] == 3)  code[c] = '3'; 
			if(ggCodes[r][c] == 4)  code[c] = '4'; 
			if(ggCodes[r][c] == 5)  code[c] = '5'; 
			if(ggCodes[r][c] == 6)  code[c] = '6'; 
			if(ggCodes[r][c] == 7)  code[c] = '7'; 
			if(ggCodes[r][c] == 8)  code[c] = '8'; 
			if(ggCodes[r][c] == 9)  code[c] = '9'; 
			if(ggCodes[r][c] == 10) code[c] = 'A'; 
			if(ggCodes[r][c] == 11) code[c] = 'B'; 
			if(ggCodes[r][c] == 12) code[c] = 'C'; 
			if(ggCodes[r][c] == 13) code[c] = 'D'; 
			if(ggCodes[r][c] == 14) code[c] = 'E'; 
			if(ggCodes[r][c] == 15) code[c] = 'F'; 
		}
		code[4] = '-';
		for(int c = 0; c < 4; c++) {
			if(ggCodes[r][c+4] == 0)  code[c+5] = '0'; 
			if(ggCodes[r][c+4] == 1)  code[c+5] = '1'; 
			if(ggCodes[r][c+4] == 2)  code[c+5] = '2'; 
			if(ggCodes[r][c+4] == 3)  code[c+5] = '3'; 
			if(ggCodes[r][c+4] == 4)  code[c+5] = '4'; 
			if(ggCodes[r][c+4] == 5)  code[c+5] = '5'; 
			if(ggCodes[r][c+4] == 6)  code[c+5] = '6'; 
			if(ggCodes[r][c+4] == 7)  code[c+5] = '7'; 
			if(ggCodes[r][c+4] == 8)  code[c+5] = '8'; 
			if(ggCodes[r][c+4] == 9)  code[c+5] = '9'; 
			if(ggCodes[r][c+4] == 10) code[c+5] = 'A'; 
			if(ggCodes[r][c+4] == 11) code[c+5] = 'B'; 
			if(ggCodes[r][c+4] == 12) code[c+5] = 'C'; 
			if(ggCodes[r][c+4] == 13) code[c+5] = 'D'; 
			if(ggCodes[r][c+4] == 14) code[c+5] = 'E'; 
			if(ggCodes[r][c+4] == 15) code[c+5] = 'F'; 
		}
		FontSetColour(color);
		FontText(code, leftXC, yC, 600); 

		//Draw description
		leftXC = 325-25;
		WCHAR codeD[28];
		for(int i = 0; i < 28; i++) codeD[i] = '\0';

		for(int c = 9; c < 9+27; c++) {
			if(ggCodes[r][c] == 16)  codeD[c-9] = 'A'; 
			if(ggCodes[r][c] == 17)  codeD[c-9] = 'B'; 
			if(ggCodes[r][c] == 18)  codeD[c-9] = 'C'; 
			if(ggCodes[r][c] == 19)  codeD[c-9] = 'D'; 
			if(ggCodes[r][c] == 20)  codeD[c-9] = 'E'; 
			if(ggCodes[r][c] == 21)  codeD[c-9] = 'F'; 
			if(ggCodes[r][c] == 22)  codeD[c-9] = 'G'; 
			if(ggCodes[r][c] == 23)  codeD[c-9] = 'H'; 
			if(ggCodes[r][c] == 24)  codeD[c-9] = 'I'; 
			if(ggCodes[r][c] == 25)  codeD[c-9] = 'J'; 
			if(ggCodes[r][c] == 26)  codeD[c-9] = 'K'; 
			if(ggCodes[r][c] == 27)  codeD[c-9] = 'L'; 
			if(ggCodes[r][c] == 28)  codeD[c-9] = 'M'; 
			if(ggCodes[r][c] == 29)  codeD[c-9] = 'N'; 
			if(ggCodes[r][c] == 30)  codeD[c-9] = 'O'; 
			if(ggCodes[r][c] == 31)  codeD[c-9] = 'P'; 
			if(ggCodes[r][c] == 32)  codeD[c-9] = 'Q'; 
			if(ggCodes[r][c] == 33)  codeD[c-9] = 'R'; 
			if(ggCodes[r][c] == 34)  codeD[c-9] = 'S'; 
			if(ggCodes[r][c] == 35)  codeD[c-9] = 'T'; 
			if(ggCodes[r][c] == 36)  codeD[c-9] = 'U'; 
			if(ggCodes[r][c] == 37)  codeD[c-9] = 'V'; 
			if(ggCodes[r][c] == 38)  codeD[c-9] = 'W'; 
			if(ggCodes[r][c] == 39)  codeD[c-9] = 'X'; 
			if(ggCodes[r][c] == 40)  codeD[c-9] = 'Y'; 
			if(ggCodes[r][c] == 41)  codeD[c-9] = 'Z'; 

			if(ggCodes[r][c] == 42)  codeD[c-9] = 'a'; 
			if(ggCodes[r][c] == 43)  codeD[c-9] = 'b'; 
			if(ggCodes[r][c] == 44)  codeD[c-9] = 'c'; 
			if(ggCodes[r][c] == 45)  codeD[c-9] = 'd'; 
			if(ggCodes[r][c] == 46)  codeD[c-9] = 'e'; 
			if(ggCodes[r][c] == 47)  codeD[c-9] = 'f'; 
			if(ggCodes[r][c] == 48)  codeD[c-9] = 'g'; 
			if(ggCodes[r][c] == 49)  codeD[c-9] = 'h'; 
			if(ggCodes[r][c] == 50)  codeD[c-9] = 'i'; 
			if(ggCodes[r][c] == 51)  codeD[c-9] = 'j'; 
			if(ggCodes[r][c] == 52)  codeD[c-9] = 'k'; 
			if(ggCodes[r][c] == 53)  codeD[c-9] = 'l'; 
			if(ggCodes[r][c] == 54)  codeD[c-9] = 'm'; 
			if(ggCodes[r][c] == 55)  codeD[c-9] = 'n'; 
			if(ggCodes[r][c] == 56)  codeD[c-9] = 'o'; 
			if(ggCodes[r][c] == 57)  codeD[c-9] = 'p'; 
			if(ggCodes[r][c] == 58)  codeD[c-9] = 'q'; 
			if(ggCodes[r][c] == 59)  codeD[c-9] = 'r'; 
			if(ggCodes[r][c] == 60)  codeD[c-9] = 's'; 
			if(ggCodes[r][c] == 61)  codeD[c-9] = 't'; 
			if(ggCodes[r][c] == 62)  codeD[c-9] = 'u'; 
			if(ggCodes[r][c] == 63)  codeD[c-9] = 'v'; 
			if(ggCodes[r][c] == 64)  codeD[c-9] = 'w'; 
			if(ggCodes[r][c] == 65)  codeD[c-9] = 'x'; 
			if(ggCodes[r][c] == 66)  codeD[c-9] = 'y'; 
			if(ggCodes[r][c] == 67)  codeD[c-9] = 'z'; 

			if(ggCodes[r][c] == 68)  codeD[c-9] = '0'; 
			if(ggCodes[r][c] == 69)  codeD[c-9] = '1'; 
			if(ggCodes[r][c] == 70)  codeD[c-9] = '2'; 
			if(ggCodes[r][c] == 71)  codeD[c-9] = '3'; 
			if(ggCodes[r][c] == 72)  codeD[c-9] = '4'; 
			if(ggCodes[r][c] == 73)  codeD[c-9] = '5'; 
			if(ggCodes[r][c] == 74)  codeD[c-9] = '6'; 
			if(ggCodes[r][c] == 75)  codeD[c-9] = '7'; 
			if(ggCodes[r][c] == 76)  codeD[c-9] = '8'; 
			if(ggCodes[r][c] == 77)  codeD[c-9] = '9'; 


			if(ggCodes[r][c] == 78)  codeD[c-9] = ' '; 
			if(ggCodes[r][c] == 79)  codeD[c-9] = '_'; 
			if(ggCodes[r][c] == 80)  codeD[c-9] = '('; 
			if(ggCodes[r][c] == 81)  codeD[c-9] = ')'; 
			if(ggCodes[r][c] == 82)  codeD[c-9] = '['; 
			if(ggCodes[r][c] == 83)  codeD[c-9] = ']'; 
			if(ggCodes[r][c] == 84)  codeD[c-9] = '{'; 
			if(ggCodes[r][c] == 85)  codeD[c-9] = '}'; 
			if(ggCodes[r][c] == 86)  codeD[c-9] = ','; 
			if(ggCodes[r][c] == 87)  codeD[c-9] = '\''; 
			if(ggCodes[r][c] == 88)  codeD[c-9] = '|'; 
			if(ggCodes[r][c] == 89)  codeD[c-9] = '+'; 
			if(ggCodes[r][c] == 90)  codeD[c-9] = '-'; 
			if(ggCodes[r][c] == 91)  codeD[c-9] = ':'; 
			if(ggCodes[r][c] == 92)  codeD[c-9] = '<'; 
			if(ggCodes[r][c] == 93)  codeD[c-9] = '>'; 
			if(ggCodes[r][c] == 94)  codeD[c-9] = '.'; 
			if(ggCodes[r][c] == 95)  codeD[c-9] = ';'; 
			if(ggCodes[r][c] == 96)  codeD[c-9] = '='; 
			if(ggCodes[r][c] == 97)  codeD[c-9] = '%'; 
			if(ggCodes[r][c] == 98)  codeD[c-9] = '~'; 
			if(ggCodes[r][c] == 99)  codeD[c-9] = '!'; 
			if(ggCodes[r][c] == 100)  codeD[c-9] = '@'; 
			if(ggCodes[r][c] == 101)  codeD[c-9] = '#'; 
			if(ggCodes[r][c] == 102)  codeD[c-9] = '$'; 
			if(ggCodes[r][c] == 103)  codeD[c-9] = '^'; 
			if(ggCodes[r][c] == 104)  codeD[c-9] = '&'; 
			if(ggCodes[r][c] == 105)  codeD[c-9] = '*'; 
			if(ggCodes[r][c] == 106)  codeD[c-9] = '`'; 
			if(ggCodes[r][c] == 107)  codeD[c-9] = '\\'; 
			if(ggCodes[r][c] == 108)  codeD[c-9] = '?'; 
		}
		FontSetColour(color);
		FontText(codeD, leftXC, yC, 600); 

		yC+= vSpace; 
		cheatDrawn++; 
	} 
}

void ggDraw() {
	if(editCheat == 0) {
		drawNoEditCheatGG();
		return;
	}

	for(int r = 0; r < 15; r++) { 
		leftXC = 75;
		for(int c = 0; c < 9+27; c++) { 
			if(c == 8) { 
				leftXC = 200; 
				if(ggCodes[r][c] == 0) drawCodeToggle("0ff", r, c); else drawCodeToggle("On", r, c); 
			} 
			else { 
				if(c < 9) { 
					if(c == 4) { drawCodeDash("-", r, c); }
					if(ggCodes[r][c] == 0)  drawCode("0", r, c); 
					if(ggCodes[r][c] == 1)  drawCode("1", r, c); 
					if(ggCodes[r][c] == 2)  drawCode("2", r, c); 
					if(ggCodes[r][c] == 3)  drawCode("3", r, c); 
					if(ggCodes[r][c] == 4)  drawCode("4", r, c); 
					if(ggCodes[r][c] == 5)  drawCode("5", r, c); 
					if(ggCodes[r][c] == 6)  drawCode("6", r, c); 
					if(ggCodes[r][c] == 7)  drawCode("7", r, c); 
					if(ggCodes[r][c] == 8)  drawCode("8", r, c); 
					if(ggCodes[r][c] == 9)  drawCode("9", r, c); 
					if(ggCodes[r][c] == 10) drawCode("A", r, c); 
					if(ggCodes[r][c] == 11) drawCode("B", r, c); 
					if(ggCodes[r][c] == 12) drawCode("C", r, c); 
					if(ggCodes[r][c] == 13) drawCode("D", r, c); 
					if(ggCodes[r][c] == 14) drawCode("E", r, c); 
					if(ggCodes[r][c] == 15) drawCode("F", r, c); 
				} 
				else { 
					//Description
					if(ggCodes[r][c] == 16)  drawCode("A", r, c); 
					if(ggCodes[r][c] == 17)  drawCode("B", r, c); 
					if(ggCodes[r][c] == 18)  drawCode("C", r, c); 
					if(ggCodes[r][c] == 19)  drawCode("D", r, c); 
					if(ggCodes[r][c] == 20)  drawCode("E", r, c); 
					if(ggCodes[r][c] == 21)  drawCode("F", r, c); 
					if(ggCodes[r][c] == 22)  drawCode("G", r, c); 
					if(ggCodes[r][c] == 23)  drawCode("H", r, c); 
					if(ggCodes[r][c] == 24)  drawCode("I", r, c); 
					if(ggCodes[r][c] == 25)  drawCode("J", r, c); 
					if(ggCodes[r][c] == 26)  drawCode("K", r, c); 
					if(ggCodes[r][c] == 27)  drawCode("L", r, c); 
					if(ggCodes[r][c] == 28)  drawCode("M", r, c); 
					if(ggCodes[r][c] == 29)  drawCode("N", r, c); 
					if(ggCodes[r][c] == 30)  drawCode("O", r, c); 
					if(ggCodes[r][c] == 31)  drawCode("P", r, c); 
					if(ggCodes[r][c] == 32)  drawCode("Q", r, c); 
					if(ggCodes[r][c] == 33)  drawCode("R", r, c); 
					if(ggCodes[r][c] == 34)  drawCode("S", r, c); 
					if(ggCodes[r][c] == 35)  drawCode("T", r, c); 
					if(ggCodes[r][c] == 36)  drawCode("U", r, c); 
					if(ggCodes[r][c] == 37)  drawCode("V", r, c); 
					if(ggCodes[r][c] == 38)  drawCode("W", r, c); 
					if(ggCodes[r][c] == 39)  drawCode("X", r, c); 
					if(ggCodes[r][c] == 40)  drawCode("Y", r, c); 
					if(ggCodes[r][c] == 41)  drawCode("Z", r, c); 

					if(ggCodes[r][c] == 42)  drawCode("a", r, c); 
					if(ggCodes[r][c] == 43)  drawCode("b", r, c); 
					if(ggCodes[r][c] == 44)  drawCode("c", r, c); 
					if(ggCodes[r][c] == 45)  drawCode("d", r, c); 
					if(ggCodes[r][c] == 46)  drawCode("e", r, c); 
					if(ggCodes[r][c] == 47)  drawCode("f", r, c); 
					if(ggCodes[r][c] == 48)  drawCode("g", r, c); 
					if(ggCodes[r][c] == 49)  drawCode("h", r, c); 
					if(ggCodes[r][c] == 50)  drawCode("i", r, c); 
					if(ggCodes[r][c] == 51)  drawCode("j", r, c); 
					if(ggCodes[r][c] == 52)  drawCode("k", r, c); 
					if(ggCodes[r][c] == 53)  drawCode("l", r, c); 
					if(ggCodes[r][c] == 54)  drawCode("m", r, c); 
					if(ggCodes[r][c] == 55)  drawCode("n", r, c); 
					if(ggCodes[r][c] == 56)  drawCode("o", r, c); 
					if(ggCodes[r][c] == 57)  drawCode("p", r, c); 
					if(ggCodes[r][c] == 58)  drawCode("q", r, c); 
					if(ggCodes[r][c] == 59)  drawCode("r", r, c); 
					if(ggCodes[r][c] == 60)  drawCode("s", r, c); 
					if(ggCodes[r][c] == 61)  drawCode("t", r, c); 
					if(ggCodes[r][c] == 62)  drawCode("u", r, c); 
					if(ggCodes[r][c] == 63)  drawCode("v", r, c); 
					if(ggCodes[r][c] == 64)  drawCode("w", r, c); 
					if(ggCodes[r][c] == 65)  drawCode("x", r, c); 
					if(ggCodes[r][c] == 66)  drawCode("y", r, c); 
					if(ggCodes[r][c] == 67)  drawCode("z", r, c); 

					if(ggCodes[r][c] == 68)  drawCode("0", r, c); 
					if(ggCodes[r][c] == 69)  drawCode("1", r, c); 
					if(ggCodes[r][c] == 70)  drawCode("2", r, c); 
					if(ggCodes[r][c] == 71)  drawCode("3", r, c); 
					if(ggCodes[r][c] == 72)  drawCode("4", r, c); 
					if(ggCodes[r][c] == 73)  drawCode("5", r, c); 
					if(ggCodes[r][c] == 74)  drawCode("6", r, c); 
					if(ggCodes[r][c] == 75)  drawCode("7", r, c); 
					if(ggCodes[r][c] == 76)  drawCode("8", r, c); 
					if(ggCodes[r][c] == 77)  drawCode("9", r, c); 


					if(ggCodes[r][c] == 78)  drawCode(" ", r, c); 
					if(ggCodes[r][c] == 79)  drawCode("_", r, c); 
					if(ggCodes[r][c] == 80)  drawCode("(", r, c); 
					if(ggCodes[r][c] == 81)  drawCode(")", r, c); 
					if(ggCodes[r][c] == 82)  drawCode("[", r, c); 
					if(ggCodes[r][c] == 83)  drawCode("]", r, c); 
					if(ggCodes[r][c] == 84)  drawCode("{", r, c); 
					if(ggCodes[r][c] == 85)  drawCode("}", r, c); 
					if(ggCodes[r][c] == 86)  drawCode(",", r, c); 
					if(ggCodes[r][c] == 87)  drawCode("\'", r, c); 
					if(ggCodes[r][c] == 88)  drawCode("|", r, c); 
					if(ggCodes[r][c] == 89)  drawCode("+", r, c); 
					if(ggCodes[r][c] == 90)  drawCode("-", r, c); 
					if(ggCodes[r][c] == 91)  drawCode(":", r, c); 
					if(ggCodes[r][c] == 92)  drawCode("<", r, c); 
					if(ggCodes[r][c] == 93)  drawCode(">", r, c); 
					if(ggCodes[r][c] == 94)  drawCode(".", r, c); 
					if(ggCodes[r][c] == 95)  drawCode(";", r, c); 
					if(ggCodes[r][c] == 96)  drawCode("=", r, c); 
					if(ggCodes[r][c] == 97)  drawCode("%", r, c); 
					if(ggCodes[r][c] == 98)  drawCode("~", r, c); 
					if(ggCodes[r][c] == 99)  drawCode("!", r, c); 
					if(ggCodes[r][c] == 100)  drawCode("@", r, c); 
					if(ggCodes[r][c] == 101)  drawCode("#", r, c); 
					if(ggCodes[r][c] == 102)  drawCode("$", r, c); 
					if(ggCodes[r][c] == 103)  drawCode("^", r, c); 
					if(ggCodes[r][c] == 104)  drawCode("&", r, c); 
					if(ggCodes[r][c] == 105)  drawCode("*", r, c); 
					if(ggCodes[r][c] == 106)  drawCode("`", r, c); 
					if(ggCodes[r][c] == 107)  drawCode("\\", r, c); 
					if(ggCodes[r][c] == 108)  drawCode("?", r, c); 


				} 
			} 
		} 
		yC+= vSpace; 
		cheatDrawn++; 
	} 
}

void drawCheatSearchMenu() {
	if(cheatSearchMode == 0) {	
	/*	WCHAR text2345[280]={0};
		wsprintfW(text2345,L"Press \"B\" to exit.");
		FontSetColour(0xffff00);
		FontSmallText(text2345,sWidth/2,70, 600);	*/

		DWORD color = 0xffffff;
		if(cheatSearchMenu == 0) color = menuColor[MenuOptionSelected]; else color = menuColor[MenuOption];
		WCHAR atext2345[280]={0};
		wsprintfW(atext2345,L"New Cheat Code Search");
		FontSetColour(color);
		FontSmallText(atext2345,sWidth/2,150, 600);

		if(cheatSearchMenu == 1) color = menuColor[MenuOptionSelected]; else color = menuColor[MenuOption];
		WCHAR datext2345[280]={0};
		wsprintfW(datext2345,L"Continue Cheat Code Search");
		FontSetColour(color);
		FontSmallText(datext2345,sWidth/2,170, 600);

	}

	if(cheatSearchMode == 1) {	
		cheatSearchMode = 4;//bypass 2 byte
	}

	if(cheatSearchMode == 2) {	
		WCHAR text2345[280]={0};
		wsprintfW(text2345,L"Press \"A\" to continue.");
		FontSetColour(0xffff00);
		FontSmallText(text2345,sWidth/2,230, 600);	

		DWORD color = 0xffffff;

		WCHAR atext2345[280]={0};
		wsprintfW(atext2345,L"The cheat code search has started.");
		FontSetColour(color);
		FontSmallText(atext2345,sWidth/2,150, 600);

		WCHAR batext2345[280]={0};
		wsprintfW(batext2345,L"Continue playing the game and then");
		FontSetColour(color);
		FontSmallText(batext2345,sWidth/2,170, 600);

		WCHAR bbatext2345[280]={0};
		wsprintfW(bbatext2345,L"choose \"Continue Cheat Code Search\".");
		FontSetColour(color);
		FontSmallText(bbatext2345,sWidth/2,190, 600);
	}

	if(cheatSearchMode == 3) {	
		/*WCHAR text2345[280]={0};
		wsprintfW(text2345,L"Press \"B\" to cancel.");
		FontSetColour(0xffff00);
		FontSmallText(text2345,sWidth/2,70, 600);	*/

		DWORD color = 0xffffff;
		if(cheatSearchMenu == 0) color = menuColor[MenuOptionSelected]; else color = menuColor[MenuOption];
		WCHAR atext2345[280]={0};
		wsprintfW(atext2345,L"Search For An Exact Value");
		FontSetColour(color);
		FontSmallText(atext2345,sWidth/2,150, 600);

		if(cheatSearchMenu == 1) color = menuColor[MenuOptionSelected]; else color = menuColor[MenuOption];
		WCHAR datext2345[280]={0};
		wsprintfW(datext2345,L"Search For Values Less Then Before");
		FontSetColour(color);
		FontSmallText(datext2345,sWidth/2,170, 600);

		if(cheatSearchMenu == 2) color = menuColor[MenuOptionSelected]; else color = menuColor[MenuOption];
		WCHAR adatext2345[280]={0};
		wsprintfW(adatext2345,L"Search For Values Less Then Or Equal To Before");
		FontSetColour(color);
		FontSmallText(adatext2345,sWidth/2,190, 600);

		if(cheatSearchMenu == 3) color = menuColor[MenuOptionSelected]; else color = menuColor[MenuOption];
		WCHAR ddatext2345[280]={0};
		wsprintfW(ddatext2345,L"Search For Values Greater Then Before");
		FontSetColour(color);
		FontSmallText(ddatext2345,sWidth/2,210, 600);

		if(cheatSearchMenu == 4) color = menuColor[MenuOptionSelected]; else color = menuColor[MenuOption];
		WCHAR dddatext2345[280]={0};
		wsprintfW(dddatext2345,L"Search For Values Greater Then Or Equal To Before");
		FontSetColour(color);
		FontSmallText(dddatext2345,sWidth/2,230, 600);

		if(cheatSearchMenu == 5) color = menuColor[MenuOptionSelected]; else color = menuColor[MenuOption];
		WCHAR ddddatext2345[280]={0};
		wsprintfW(ddddatext2345,L"Search For Values Not Equal To Before");
		FontSetColour(color);
		FontSmallText(ddddatext2345,sWidth/2,250, 600);

		if(cheatSearchMenu == 6) color = menuColor[MenuOptionSelected]; else color = menuColor[MenuOption];
		WCHAR fddddatext2345[280]={0};
		wsprintfW(fddddatext2345,L"Search For Values Equal To Before");
		FontSetColour(color);
		FontSmallText(fddddatext2345,sWidth/2,270, 600);
	}

	if(cheatSearchMode == 4) {	
		DWORD color = 0xffffff;
		//if(oneByteSearch == true) {
		WCHAR bbatext2345[280]={0};
		wsprintfW(bbatext2345,L"Please enter a value between 0 and 255.");
		FontSetColour(color);
		FontSmallText(bbatext2345,sWidth/2,190, 600);

		WCHAR abbatext2345[280]={0};
		wsprintfW(abbatext2345,L"Select a digit and press \"A\" to increase.");
		FontSetColour(color);
		FontSmallText(abbatext2345,sWidth/2,210, 600);

		WCHAR aabbatext2345[280]={0};
		wsprintfW(aabbatext2345,L"or \"X\" to decrease.");
		FontSetColour(color);
		FontSmallText(aabbatext2345,sWidth/2,230, 600);

		WCHAR text2345[280]={0};
		wsprintfW(text2345,L"Press \"Y\" to search for above value.");
		FontSetColour(0xffff00);
		FontSmallText(text2345,sWidth/2,290, 600);

		//WCHAR utext2345[280]={0};
		//wsprintfW(utext2345,L"Press \"B\" to cancel.");
		//FontSetColour(0xffff00);
		//FontSmallText(utext2345,sWidth/2,70, 600);	

		oneByteDraw();
	}

	if(cheatSearchMode == 7) {	
		//if(oneByteSearch == true) {
		WCHAR text2345[280]={0};
		wsprintfW(text2345,L"Press \"A\" to continue.");
		FontSetColour(0xffff00);
		FontSmallText(text2345,sWidth/2,250, 600);	

		DWORD color = 0xffff00;
		WCHAR atext2345[280]={0};
		wsprintfW(atext2345,L"Invalid number entered");
		FontSetColour(color);
		FontSmallText(atext2345,sWidth/2,150, 600);

		color = 0xffffff;
		WCHAR batext2345[280]={0};
		wsprintfW(batext2345,L"Please enter a value between 0 and 255.");
		FontSetColour(color);
		FontSmallText(batext2345,sWidth/2,190, 600);
	}

	if(cheatSearchMode == 5) {	
		WCHAR text2345[280]={0};
		wsprintfW(text2345,L"Press \"A\" to view results.");
		FontSetColour(0xffff00);
		FontSmallText(text2345,sWidth/2,230, 600);	

		DWORD color = 0x00ff00;

		WCHAR atext2345[280]={0};
		wsprintfW(atext2345,L"Total Results Found: %d", cheatResultsFound);
		FontSetColour(color);
		FontSmallText(atext2345,sWidth/2,150, 600);
	}

	if(cheatSearchMode == 8) {	
		/*WCHAR utext2345[280]={0};
		wsprintfW(utext2345,L"Press \"B\" to cancel.");
		FontSetColour(0xffff00);
		FontSmallText(utext2345,sWidth/2,70, 600);	*/

		DWORD color = 0x00ff00;
		int y = 100;
		for(int i = 0; i < wramCheats.size(); i++) {
			WCHAR atext2345[280]={0};
			if(cheatSearchMenu == i) color = menuColor[MenuOptionSelected]; else color = menuColor[MenuOption];
			wsprintfW(atext2345,L"Address: %d, Current Value: %d, Previous Value: %d", wramCheats[i].address, wramCheats[i].cvalue, wramCheats[i].pvalue);
			FontSetColour(color);
			FontSmallText(atext2345,sWidth/2,y, 600);	
			y+=20;
		}
		for(int i = 0; i < ram7fCheats.size(); i++) {
			WCHAR atext2345[280]={0};
			if(cheatSearchMenu == (i + wramCheats.size())) color = menuColor[MenuOptionSelected]; else color = menuColor[MenuOption];
			wsprintfW(atext2345,L"Address: %d, Current Value: %d, Previous Value: %d", ram7fCheats[i].address, ram7fCheats[i].cvalue, ram7fCheats[i].pvalue);
			FontSetColour(color);
			FontSmallText(atext2345,sWidth/2,y, 600);	
			y+=20;
		}

		for(int i = 0; i < sramCheats.size(); i++) {
			WCHAR atext2345[280]={0};
			if(cheatSearchMenu == (i + wramCheats.size() + ram7fCheats.size())) color = menuColor[MenuOptionSelected]; else color = menuColor[MenuOption];
			wsprintfW(atext2345,L"Address: %d, Current Value: %d, Previous Value: %d", sramCheats[i].address, sramCheats[i].cvalue, sramCheats[i].pvalue);
			FontSetColour(color);
			FontSmallText(atext2345,sWidth/2,y, 600);	
			y+=20;
		}


		WCHAR rutext2345[280]={0};
		wsprintfW(rutext2345,L"Select a line and press \"A\" to create a new code.");
		FontSetColour(0xffff00);
		FontSmallText(rutext2345,sWidth/2,480-55, 600);	
	}

	if(cheatSearchMode == 6) {	
		WCHAR text2345[280]={0};
		wsprintfW(text2345,L"Press \"A\" to continue.");
		FontSetColour(0xffff00);
		FontSmallText(text2345,sWidth/2,250, 600);	

		DWORD color = 0x00ff00;

		WCHAR atext2345[280]={0};
		wsprintfW(atext2345,L"Total Results Found: %d", cheatResultsFound);
		FontSetColour(color);
		FontSmallText(atext2345,sWidth/2,150, 600);

		color = 0xffffff;
		WCHAR batext2345[280]={0};
		wsprintfW(batext2345,L"Please continue searching until the");
		FontSetColour(color);
		FontSmallText(batext2345,sWidth/2,190, 600);

		WCHAR bbatext2345[280]={0};
		wsprintfW(bbatext2345,L"number of results found are between 1 and 15.");
		FontSetColour(color);
		FontSmallText(bbatext2345,sWidth/2,210, 600);
	}

	if(cheatSearchMode == 9) {	
		DWORD color = 0xffffff;
		WCHAR bbatext2345[280]={0};
		wsprintfW(bbatext2345,L"Please enter a value between 0 and 255 to use for this code.");
		FontSetColour(color);
		FontSmallText(bbatext2345,sWidth/2,190, 600);

		WCHAR sbbatext2345[280]={0};
		wsprintfW(sbbatext2345,L"For example: If this RAM address represents the ");
		FontSetColour(color);
		FontSmallText(sbbatext2345,sWidth/2,230, 600);

		WCHAR ssbbatext2345[280]={0};
		wsprintfW(ssbbatext2345,L"number of lives, then you could enter 50 so ");
		FontSetColour(color);
		FontSmallText(ssbbatext2345,sWidth/2,250, 600);

		WCHAR sssbbatext2345[280]={0};
		wsprintfW(sssbbatext2345,L"the character would allways have 50 lives.");
		FontSetColour(color);
		FontSmallText(sssbbatext2345,sWidth/2,270, 600);

		WCHAR abbatext2345[280]={0};
		wsprintfW(abbatext2345,L"Select a digit and press \"A\" to increase.");
		FontSetColour(color);
		FontSmallText(abbatext2345,sWidth/2,310, 600);

		WCHAR aabbatext2345[280]={0};
		wsprintfW(aabbatext2345,L"or \"X\" to decrease.");
		FontSetColour(color);
		FontSmallText(aabbatext2345,sWidth/2,330, 600);

		WCHAR text2345[280]={0};
		wsprintfW(text2345,L"Press \"Y\" to continue.");
		FontSetColour(0xffff00);
		FontSmallText(text2345,sWidth/2,480-90, 600);

		/*WCHAR utext2345[280]={0};
		wsprintfW(utext2345,L"Press \"B\" to cancel.");
		FontSetColour(0xffff00);
		FontSmallText(utext2345,sWidth/2,70, 600);*/	

		oneByteDraw();
	}

	if(cheatSearchMode == 10) {	
		//if(oneByteSearch == true) {
		WCHAR text2345[280]={0};
		wsprintfW(text2345,L"Press \"A\" to continue.");
		FontSetColour(0xffff00);
		FontSmallText(text2345,sWidth/2,250, 600);	

		DWORD color = 0xffff00;
		WCHAR atext2345[280]={0};
		wsprintfW(atext2345,L"Invalid number entered");
		FontSetColour(color);
		FontSmallText(atext2345,sWidth/2,150, 600);

		color = 0xffffff;
		WCHAR batext2345[280]={0};
		wsprintfW(batext2345,L"Please enter a value between 0 and 255.");
		FontSetColour(color);
		FontSmallText(batext2345,sWidth/2,190, 600);
	}

	if(cheatSearchMode == 11) {
		/*WCHAR text2345[280]={0};
		wsprintfW(text2345,L"Press \"B\" to cancel.");
		FontSetColour(0xffff00);
		FontSmallText(text2345,sWidth/2,70, 600);	*/

		WCHAR atext2345[280]={0};
		wsprintfW(atext2345,L"Please select where to put the cheat code and press \"A\".");
		FontSetColour(0xffff00);
		FontSmallText(atext2345,sWidth/2,480-55, 600);

		DWORD color = 0xffff00;
		int y = 110;
		for(int i = 0; i < 15; i++) {
			WCHAR atext2345[280]={0};
			if(cheatSearchMenu == i) color = menuColor[MenuOptionSelected]; else color = menuColor[MenuOption];
			wsprintfW(atext2345,L"Cheat Search Code %d", (i+1));
			FontSetColour(color);
			FontSmallText(atext2345,sWidth/2,y, 600);	
			y+=20;
		}
	}

	if(cheatSearchMode == 12) {	
		//if(oneByteSearch == true) {
		WCHAR text2345[280]={0};
		wsprintfW(text2345,L"Press \"A\" to continue.");
		FontSetColour(0xffff00);
		FontSmallText(text2345,sWidth/2,(480/2), 600);	

		DWORD color = 0xffffff;
		WCHAR atext2345[280]={0};
		wsprintfW(atext2345,L"Cheat code successfully created");
		FontSetColour(color);
		FontSmallText(atext2345,sWidth/2,(150), 600);

		//DWORD color = 0xffffff;
		WCHAR gatext2345[280]={0};
		wsprintfW(gatext2345,L"The code is disabled by default.");
		FontSetColour(color);
		FontSmallText(gatext2345,sWidth/2,170, 600);

	}
}

void drawTCRTextRPV(char* text) {
	DWORD color  = menuColor[MenuOption]; 
	if(row == drawE) color = menuColor[MenuOptionSelected]; 
	WCHAR text23456789[80]={0};

	for(int i = 0; i < 1000; i++) {
		if(text[i] == '\0') {
			text23456789[i] = '\0';
			break;
		}
		text23456789[i] = text[i];
	}
	FontSetColour(color);
	FontSmallText(text23456789,155+zLeftRM,yO+zTopRM, 600);
	yO += vSpace;
	drawE++;
}

void drawCheatOptionsMenu() { 
	yC = 105; 
	cheatDrawn = 0; 

	if(cheatMode == 4) {
		drawCheatSearchMenu();
		return;
	}

	if(cheatMode == -1) {
		/*WCHAR text2345[280]={0};
		wsprintfW(text2345,L"Press \"B\" to exit.");
		FontSetColour(0xffff00);
		FontSmallText(text2345,sWidth/2,70, 600);	*/

		DWORD color = 0xffffff;
		if(cheatMenu == 0) color = menuColor[MenuOptionSelected]; else color = menuColor[MenuOption];
		WCHAR atext2345[280]={0};
		wsprintfW(atext2345,L"Cheat Codes");
		FontSetColour(color);
		FontSmallText(atext2345,sWidth/2,150, 600);

		if(cheatMenu == 1) color = menuColor[MenuOptionSelected]; else color = menuColor[MenuOption];
		WCHAR datext2345[280]={0};
		wsprintfW(datext2345,L"Search For Cheat Codes");
		FontSetColour(color);
		FontSmallText(datext2345,sWidth/2,170, 600);

		if(cheatMenu == 2) color = menuColor[MenuOptionSelected]; else color = menuColor[MenuOption];
		WCHAR fdatext2345[280]={0};
		wsprintfW(fdatext2345,L"Game Genie Database");
		FontSetColour(color);
		FontSmallText(fdatext2345,sWidth/2,190, 600);

		if(cheatMenu == 3) color = menuColor[MenuOptionSelected]; else color = menuColor[MenuOption];
		WCHAR lfdatext2345[280]={0};
		wsprintfW(lfdatext2345,L"Pro Action Replay Database");
		FontSetColour(color);
		FontSmallText(lfdatext2345,sWidth/2,210, 600);

		if(cheatMenu == 4) color = menuColor[MenuOptionSelected]; else color = menuColor[MenuOption];
		WCHAR flfdatext2345[280]={0};
		wsprintfW(flfdatext2345,L"Tips and Tricks Database");
		FontSetColour(color);
		FontSmallText(flfdatext2345,sWidth/2,230, 600);
	}

	if(cheatMode == 0) {
		/*WCHAR text2345[280]={0};
		wsprintfW(text2345,L"Press \"B\" to exit.");
		FontSetColour(0xffff00);
		FontSmallText(text2345,sWidth/2,70, 600);	*/

		DWORD color = 0xffffff;
		if(cheatMenu == 0) color = menuColor[MenuOptionSelected]; else color = menuColor[MenuOption];
		WCHAR atext2345[280]={0};
		wsprintfW(atext2345,L"Pro Action Replay Codes");
		FontSetColour(color);
		FontSmallText(atext2345,sWidth/2,150, 600);

		if(cheatMenu == 1) color = menuColor[MenuOptionSelected]; else color = menuColor[MenuOption];
		WCHAR datext2345[280]={0};
		wsprintfW(datext2345,L"Game Genie Codes");
		FontSetColour(color);
		FontSmallText(datext2345,sWidth/2,170, 600);

		if(cheatMenu == 2) color = menuColor[MenuOptionSelected]; else color = menuColor[MenuOption];
		WCHAR edatext2345[280]={0};
		wsprintfW(edatext2345,L"Cheat Search Codes");
		FontSetColour(color);
		FontSmallText(edatext2345,sWidth/2,190, 600);

		if(cheatMenu == 3) color = menuColor[MenuOptionSelected]; else color = menuColor[MenuOption];
		WCHAR hedatext2345[280]={0};
		wsprintfW(hedatext2345,L"Edit Cheat Code Descriptions");
		FontSetColour(color);
		FontSmallText(hedatext2345,sWidth/2,210, 600);
	}

	if(cheatMode == -5) {
		/*WCHAR text2345[280]={0};
		wsprintfW(text2345,L"Press \"B\" to exit.");
		FontSetColour(0xffff00);
		FontSmallText(text2345,sWidth/2,70, 600);	*/

		DWORD color = 0xffffff;
		if(cheatMenu == 0) color = menuColor[MenuOptionSelected]; else color = menuColor[MenuOption];
		WCHAR atext2345[280]={0};
		wsprintfW(atext2345,L"Edit Pro Action Replay Code Descriptions");
		FontSetColour(color);
		FontSmallText(atext2345,sWidth/2,150, 600);

		if(cheatMenu == 1) color = menuColor[MenuOptionSelected]; else color = menuColor[MenuOption];
		WCHAR datext2345[280]={0};
		wsprintfW(datext2345,L"Edit Game Genie Code Descriptions");
		FontSetColour(color);
		FontSmallText(datext2345,sWidth/2,170, 600);

		if(cheatMenu == 2) color = menuColor[MenuOptionSelected]; else color = menuColor[MenuOption];
		WCHAR edatext2345[280]={0};
		wsprintfW(edatext2345,L"Edit Cheat Search Code Descriptions");
		FontSetColour(color);
		FontSmallText(edatext2345,sWidth/2,190, 600);
	}

	if(cheatMode == 1) {
		if(editCheat == 0) {
			/*WCHAR text2345[280]={0};
			wsprintfW(text2345,L"Press \"B\" to exit.");
			FontSetColour(0xffff00);
			FontSmallText(text2345,sWidth/2,70, 600);	*/
		}
		else {
			/*WCHAR text2345[280]={0};
			wsprintfW(text2345,L"Press \"B\" to exit.");
			FontSetColour(0xffff00);
			FontSmallText(text2345,sWidth/2,70, 600);	*/
		}

		proDraw();
	}

	if(cheatMode == 20) {
		yO = 90;
		drawE = 0;
		//WCHAR text2345[280]={0};
		/*wsprintfW(text2345,L"Press \"B\" to exit.");
		FontSetColour(0xffff00);
		FontSmallText(text2345,sWidth/2,70, 600);*/
		//Draw 15 slots
		drawTCRTextRPV("Pro Action Replay Code 1"); 
		drawTCRTextRPV("Pro Action Replay Code 2"); 
		drawTCRTextRPV("Pro Action Replay Code 3"); 
		drawTCRTextRPV("Pro Action Replay Code 4"); 
		drawTCRTextRPV("Pro Action Replay Code 5"); 
		drawTCRTextRPV("Pro Action Replay Code 6"); 
		drawTCRTextRPV("Pro Action Replay Code 7"); 
		drawTCRTextRPV("Pro Action Replay Code 8"); 
		drawTCRTextRPV("Pro Action Replay Code 9"); 
		drawTCRTextRPV("Pro Action Replay Code 10"); 
		drawTCRTextRPV("Pro Action Replay Code 11"); 
		drawTCRTextRPV("Pro Action Replay Code 12"); 
		drawTCRTextRPV("Pro Action Replay Code 13"); 
		drawTCRTextRPV("Pro Action Replay Code 14"); 
		drawTCRTextRPV("Pro Action Replay Code 15");
	}

	if(cheatMode == 21) {
		yO = 90;
		drawE = 0;
		//WCHAR text2345[280]={0};
		/*wsprintfW(text2345,L"Press \"B\" to exit.");
		FontSetColour(0xffff00);
		FontSmallText(text2345,sWidth/2,70, 600);*/

		drawTCRTextRPV("Game Genie Code 1"); 
		drawTCRTextRPV("Game Genie Code 2"); 
		drawTCRTextRPV("Game Genie Code 3"); 
		drawTCRTextRPV("Game Genie Code 4"); 
		drawTCRTextRPV("Game Genie Code 5"); 
		drawTCRTextRPV("Game Genie Code 6"); 
		drawTCRTextRPV("Game Genie Code 7"); 
		drawTCRTextRPV("Game Genie Code 8"); 
		drawTCRTextRPV("Game Genie Code 9"); 
		drawTCRTextRPV("Game Genie Code 10"); 
		drawTCRTextRPV("Game Genie Code 11");
		drawTCRTextRPV("Game Genie Code 12"); 
		drawTCRTextRPV("Game Genie Code 13"); 
		drawTCRTextRPV("Game Genie Code 14"); 
		drawTCRTextRPV("Game Genie Code 15");
		//Draw 15 slots
	}

	if(cheatMode == 22) {
		yO = 90;
		drawE = 0;
		//WCHAR text2345[280]={0};
		/*wsprintfW(text2345,L"Press \"B\" to exit.");
		FontSetColour(0xffff00);
		FontSmallText(text2345,sWidth/2,70, 600);*/

		//Draw 15 slots
		drawTCRTextRPV("Cheat Search Code 1"); 
		drawTCRTextRPV("Cheat Search Code 2"); 
		drawTCRTextRPV("Cheat Search Code 3"); 
		drawTCRTextRPV("Cheat Search Code 4"); 
		drawTCRTextRPV("Cheat Search Code 5"); 
		drawTCRTextRPV("Cheat Search Code 6"); 
		drawTCRTextRPV("Cheat Search Code 7"); 
		drawTCRTextRPV("Cheat Search Code 8"); 
		drawTCRTextRPV("Cheat Search Code 9"); 
		drawTCRTextRPV("Cheat Search Code 10"); 
		drawTCRTextRPV("Cheat Search Code 11"); 
		drawTCRTextRPV("Cheat Search Code 12"); 
		drawTCRTextRPV("Cheat Search Code 13"); 
		drawTCRTextRPV("Cheat Search Code 14"); 
		drawTCRTextRPV("Cheat Search Code 15");
	}

	if(cheatMode == 2) {
		if(editCheat == 0) {
			/*WCHAR text2345[280]={0};
			wsprintfW(text2345,L"Press \"B\" to exit.");
			FontSetColour(0xffff00);
			FontSmallText(text2345,sWidth/2,70, 600);	*/
		}
		else {
			/*WCHAR text2345[280]={0};
			wsprintfW(text2345,L"Press \"B\" to exit.");
			FontSetColour(0xffff00);
			FontSmallText(text2345,sWidth/2,70, 600);	*/
		}
		ggDraw();
	}

	if(cheatMode == 3) {
		if(editCheat == 0) {
			/*WCHAR text2345[280]={0};
			wsprintfW(text2345,L"Press \"B\" to exit.");
			FontSetColour(0xffff00);
			FontSmallText(text2345,sWidth/2,70, 600);	*/
		}
		else {
			/*WCHAR text2345[280]={0};
			wsprintfW(text2345,L"Press \"B\" to exit.");
			FontSetColour(0xffff00);
			FontSmallText(text2345,sWidth/2,70, 600);	*/
		}
		csDraw();
	}

	if(cheatMode == 5) {
		/*WCHAR text2345[280]={0};
		wsprintfW(text2345,L"Press \"B\" to exit.");
		FontSetColour(0xffff00);
		FontSmallText(text2345,sWidth/2,70, 600);	*/
		drawCheatCodeList();
	}
} 


void setMemoryLo(unsigned short address, unsigned char bank, unsigned char data, int bankSize) {
	if((bank >= 0x80 &&  bank <= 0xEF)) bank -= 0x80;
	if((bank >= 0xF0 && bank <= 0xFF)) bank = (bank - 0xF0) + 0x30;

	//$00-$3f
	if((bank >= 0x00 && bank <= 0x3F)) {
		if(address <= 0x1FFF) {
			wramdataa[address] = data;
		}
		if(address >= 0x8000) {
			romdata[(bank * bankSize) + (address &  0x7FFF)] = data;
		}
	}

	//$40-$6f
	if((bank >= 0x40 &&  bank <= 0x6F)) {
		if(address >= 0x8000) {
			romdata[(bank * bankSize) + (address &  0x7FFF)] = data;
		}
	}

	//$70-$77
	if((bank >= 0x70 &&  bank <= 0x77)) {
		srama[((bank-0x70) * 256 * 1024) + address] = data;
	}

	//7E
	if((bank == 0x7E) && (address < 0x8000)) {
		wramdataa[address] = data;
	}
	if((bank == 0x7E) && (address >= 0x8000)) {
		wramdataa[address] = data;
		//ram7fa[address] = data;
		//ram7f[address] = data;
	}
	//7F
	if(bank == 0x7F) {
		ram7fa[address] = data;
	}
}

unsigned char getMemoryLo(unsigned short address, unsigned char bank, int bankSize) {
	if((bank >= 0x80 &&  bank <= 0xEF)) bank -= 0x80;
	if((bank >= 0xF0 && bank <= 0xFF)) bank = (bank - 0xF0) + 0x30;

	//$00-$3f
	if((bank >= 0x00 && bank <= 0x3F)) {
		if(address <= 0x1FFF) {
			return wramdataa[address];
		}
		if(address >= 0x8000) {
			return romdata[(bank * bankSize) + (address &  0x7FFF)];
		}
	}

	//$40-$6f
	if((bank >= 0x40 &&  bank <= 0x6F)) {
		if(address >= 0x8000) {
			return romdata[(bank * bankSize) + (address &  0x7FFF)];
		}
	}

	//$70-$77
	if((bank >= 0x70 &&  bank <= 0x77)) {
		return srama[((bank-0x70) * 256 * 1024) + address];
	}

	//7E
	if((bank == 0x7E) && (address < 0x8000)) {
		return wramdataa[address];
	}

	if((bank == 0x7E) && (address >= 0x8000)) {
		return wramdataa[address];
	}

	//7F
	if(bank == 0x7F) {
		return ram7fa[address];
	}
	return 0;

}

void applyCheatCodesLoROM() {
	for(int r = 0; r < 15; r++) { 

		if(Codes[r][8] == 1) { 
			unsigned short address  = (Codes[r][2] << 12) | (Codes[r][3] << 8) | (Codes[r][4] << 4) | (Codes[r][5]);
			unsigned char  bank     = (Codes[r][0] << 4)  |  Codes[r][1];
			unsigned char  data     = (Codes[r][6] << 4)  |  Codes[r][7];
			int            bankSize = 32 * 1024;
			if(saveCodes[r] == 0) { saveCodes[r] = 1; prevCodes[r] = getMemoryLo(address, bank, bankSize); }
			resetCode[r] = 1;
			setMemoryLo(address, bank, data, bankSize);
		}
		else {
			if(saveCodes[r] == 1 && resetCode[r] == 1) {
				resetCode[r] = 0;
				unsigned short address  = (Codes[r][2] << 12) | (Codes[r][3] << 8) | (Codes[r][4] << 4) | (Codes[r][5]);
				unsigned char  bank     = (Codes[r][0] << 4)  |  Codes[r][1];
				unsigned char  data     = prevCodes[r];
				int            bankSize = 32 * 1024;
				setMemoryLo(address, bank, data, bankSize);
			}
		}
	}

	for(int r = 0; r < 15; r++) { 

		if(csCodes[r][8] == 1) { 
			unsigned short address  = (csCodes[r][2] << 12) | (csCodes[r][3] << 8) | (csCodes[r][4] << 4) | (csCodes[r][5]);
			unsigned char  bank     = (csCodes[r][0] << 4)  |  csCodes[r][1];
			unsigned char  data     = (csCodes[r][6] << 4)  |  csCodes[r][7];

			if(cssaveCodes[r] == 0) { 
				cssaveCodes[r] = 1; 
				if(bank == 0) csprevCodes[r] = wramdataa[address];
				if(bank == 1) csprevCodes[r] = ram7fa[address];
				if(bank == 2) csprevCodes[r] = srama[address];
			}
			csresetCode[r] = 1;
			if(bank == 0) wramdataa[address] = data;
			if(bank == 1) ram7fa[address] = data;
			if(bank == 2) srama[address] = data;
		}
		else {
			if(cssaveCodes[r] == 1 && csresetCode[r] == 1) {
				csresetCode[r] = 0;
				unsigned short address  = (csCodes[r][2] << 12) | (csCodes[r][3] << 8) | (csCodes[r][4] << 4) | (csCodes[r][5]);
				unsigned char  bank     = (csCodes[r][0] << 4)  |  csCodes[r][1];
				unsigned char  data     = csprevCodes[r];
				int            bankSize = 32 * 1024;
				if(bank == 0) wramdataa[address] = data;
				if(bank == 1) ram7fa[address] = data;
				if(bank == 2) srama[address] = data;
			}
		}
	}


	//Game Genie
	for(int r = 0; r < 15; r++) { 
		if(ggCodes[r][8] == 1) { 
			unsigned char data;
			int bankSize = 32 * 1024;

			unsigned int addr;
			char code[10];
			for(int i = 0; i < 10; i++) code[i] = '\0';
			for(int c = 0; c < 4; c++) {
				if(ggCodes[r][c] == 0)  code[c] = '0'; 
				if(ggCodes[r][c] == 1)  code[c] = '1'; 
				if(ggCodes[r][c] == 2)  code[c] = '2'; 
				if(ggCodes[r][c] == 3)  code[c] = '3'; 
				if(ggCodes[r][c] == 4)  code[c] = '4'; 
				if(ggCodes[r][c] == 5)  code[c] = '5'; 
				if(ggCodes[r][c] == 6)  code[c] = '6'; 
				if(ggCodes[r][c] == 7)  code[c] = '7'; 
				if(ggCodes[r][c] == 8)  code[c] = '8'; 
				if(ggCodes[r][c] == 9)  code[c] = '9'; 
				if(ggCodes[r][c] == 10) code[c] = 'A'; 
				if(ggCodes[r][c] == 11) code[c] = 'B'; 
				if(ggCodes[r][c] == 12) code[c] = 'C'; 
				if(ggCodes[r][c] == 13) code[c] = 'D'; 
				if(ggCodes[r][c] == 14) code[c] = 'E'; 
				if(ggCodes[r][c] == 15) code[c] = 'F'; 
			}
			code[4] = '-';
			for(int c = 0; c < 4; c++) {
				if(ggCodes[r][c+4] == 0)  code[c+5] = '0'; 
				if(ggCodes[r][c+4] == 1)  code[c+5] = '1'; 
				if(ggCodes[r][c+4] == 2)  code[c+5] = '2'; 
				if(ggCodes[r][c+4] == 3)  code[c+5] = '3'; 
				if(ggCodes[r][c+4] == 4)  code[c+5] = '4'; 
				if(ggCodes[r][c+4] == 5)  code[c+5] = '5'; 
				if(ggCodes[r][c+4] == 6)  code[c+5] = '6'; 
				if(ggCodes[r][c+4] == 7)  code[c+5] = '7'; 
				if(ggCodes[r][c+4] == 8)  code[c+5] = '8'; 
				if(ggCodes[r][c+4] == 9)  code[c+5] = '9'; 
				if(ggCodes[r][c+4] == 10) code[c+5] = 'A'; 
				if(ggCodes[r][c+4] == 11) code[c+5] = 'B'; 
				if(ggCodes[r][c+4] == 12) code[c+5] = 'C'; 
				if(ggCodes[r][c+4] == 13) code[c+5] = 'D'; 
				if(ggCodes[r][c+4] == 14) code[c+5] = 'E'; 
				if(ggCodes[r][c+4] == 15) code[c+5] = 'F'; 
			}


			const char* t = S9xGameGenieToRaw (code, addr, data);

			if(t != NULL) 

				if(ggsaveCodes[r] == 0) { 
					ggsaveCodes[r] = 1; 
					ggprevCodes[r] = getMemoryLo(((unsigned short)(addr & 0x00FFFF)), ((unsigned char)(addr >> 16)), bankSize); 
				}

				ggresetCode[r] = 1;
				setMemoryLo(((unsigned short)(addr & 0x00FFFF)), ((unsigned char)(addr >> 16)) , data, bankSize);
		}
		else {
			if(ggsaveCodes[r] == 1 && ggresetCode[r] == 1) {
				ggresetCode[r] = 0;
				unsigned int addr;
				char code[10];
				unsigned char  data;


				for(int i = 0; i < 10; i++) code[i] = '\0';
				for(int c = 0; c < 4; c++) {
					if(ggCodes[r][c] == 0)  code[c] = '0'; 
					if(ggCodes[r][c] == 1)  code[c] = '1'; 
					if(ggCodes[r][c] == 2)  code[c] = '2'; 
					if(ggCodes[r][c] == 3)  code[c] = '3'; 
					if(ggCodes[r][c] == 4)  code[c] = '4'; 
					if(ggCodes[r][c] == 5)  code[c] = '5'; 
					if(ggCodes[r][c] == 6)  code[c] = '6'; 
					if(ggCodes[r][c] == 7)  code[c] = '7'; 
					if(ggCodes[r][c] == 8)  code[c] = '8'; 
					if(ggCodes[r][c] == 9)  code[c] = '9'; 
					if(ggCodes[r][c] == 10) code[c] = 'A'; 
					if(ggCodes[r][c] == 11) code[c] = 'B'; 
					if(ggCodes[r][c] == 12) code[c] = 'C'; 
					if(ggCodes[r][c] == 13) code[c] = 'D'; 
					if(ggCodes[r][c] == 14) code[c] = 'E'; 
					if(ggCodes[r][c] == 15) code[c] = 'F'; 
				}
				code[4] = '-';
				for(int c = 0; c < 4; c++) {
					if(ggCodes[r][c+4] == 0)  code[c+5] = '0'; 
					if(ggCodes[r][c+4] == 1)  code[c+5] = '1'; 
					if(ggCodes[r][c+4] == 2)  code[c+5] = '2'; 
					if(ggCodes[r][c+4] == 3)  code[c+5] = '3'; 
					if(ggCodes[r][c+4] == 4)  code[c+5] = '4'; 
					if(ggCodes[r][c+4] == 5)  code[c+5] = '5'; 
					if(ggCodes[r][c+4] == 6)  code[c+5] = '6'; 
					if(ggCodes[r][c+4] == 7)  code[c+5] = '7'; 
					if(ggCodes[r][c+4] == 8)  code[c+5] = '8'; 
					if(ggCodes[r][c+4] == 9)  code[c+5] = '9'; 
					if(ggCodes[r][c+4] == 10) code[c+5] = 'A'; 
					if(ggCodes[r][c+4] == 11) code[c+5] = 'B'; 
					if(ggCodes[r][c+4] == 12) code[c+5] = 'C'; 
					if(ggCodes[r][c+4] == 13) code[c+5] = 'D'; 
					if(ggCodes[r][c+4] == 14) code[c+5] = 'E'; 
					if(ggCodes[r][c+4] == 15) code[c+5] = 'F'; 
				}
				const char* t = S9xGameGenieToRaw (code, addr, data);

				if(t != NULL) 
					data     = ggprevCodes[r];
				int            bankSize = 32 * 1024;
				setMemoryLo(((unsigned short)(addr & 0x00FFFF)), ((unsigned char)(addr >> 16)) , data, bankSize);
			}
		}
	}
}


void setMemoryHi(unsigned short address, unsigned char bank, unsigned char data, int bankSize) {
	//Handle 00 - 6F mirroring
	if((bank >= 0xC0 &&  bank <= 0xEF)) {
		if(address <= 0x7FFF)
			bank -= 0x80;
		else
			bank -= 0xC0;
	}
	if((bank >= 0x80 &&  bank <= 0xBF)) bank -= 0x80;


	//$00-$3f
	if((bank >= 0x00 && bank <= 0x2F) ||(bank == 0x7E)) {
		if(address <= 0x1FFF) {

			wramdataa[address] = data;
		}
		if(address >= 0x8000) {

			romdata[(bank * bankSize) + address] = data;//This works for all codes except any FF3
		}
	}

	if((bank >= 0x30 && bank <= 0x3F) ||(bank == 0x7E)) {
		if(address <= 0x1FFF) {

			wramdataa[address] = data;
		}
		if(address >= 0x6000 && address <= 0x7FFF) {

			srama[(bank * 256 * 1024) + address] = data;
		}
		if(address >= 0x8000) {

			romdata[(bank * bankSize) + address] = data;
		}
	}

	//40 - 6F
	if((bank >= 0x40 &&  bank <= 0x6F)) {
		if(address < 0x8000) {

			romdata[((bank-0x40) * bankSize) + address] = data;
		}
	}

	//$70-$77
	if((bank >= 0x70 &&  bank <= 0x77)) {

		srama[((bank-0x70) * 256 * 1024) + address] = data;
	}

	//7E
	if((bank == 0x7E)) {
		if (address <= 0x1FFF) {

			wramdataa[address] = data;
		}
		if (address >= 0x2000 && address <= 0x7FFF) {

			wramdataa[address] = data;
		}
		if (address >= 0x8000) { 

			ram7fa[address] = data;
		}
	}

	//7F
	if(bank == 0x7F) {

		ram7fa[address] = data;
	}
}


unsigned char getMemoryHi(unsigned short address, unsigned char bank, int bankSize) {
	//Handle 00 - 6F mirroring
	if((bank >= 0xC0 &&  bank <= 0xEF)) {
		if(address <= 0x7FFF)
			bank -= 0x80;
		else
			bank -= 0xC0;
	}
	if((bank >= 0x80 &&  bank <= 0xBF)) bank -= 0x80;


	//$00-$3f
	if((bank >= 0x00 && bank <= 0x2F) ||(bank == 0x7E)) {
		if(address <= 0x1FFF) {
			return wramdataa[address];
		}
		if(address >= 0x8000) {
			return romdata[(bank * bankSize) + address];//This works for all codes except any FF3
		}
	}

	if((bank >= 0x30 && bank <= 0x3F) ||(bank == 0x7E)) {
		if(address <= 0x1FFF) {
			return wramdataa[address];
		}
		if(address >= 0x6000 && address <= 0x7FFF) {
			return srama[(bank * 256 * 1024) + address];
		}
		if(address >= 0x8000) {
			return romdata[(bank * bankSize) + address];
		}
	}

	//40 - 6F
	if((bank >= 0x40 &&  bank <= 0x6F)) {
		if(address < 0x8000) {
			return romdata[((bank-0x40) * bankSize) + address];
		}
	}

	//$70-$77
	if((bank >= 0x70 &&  bank <= 0x77)) {
		return srama[((bank-0x70) * 256 * 1024) + address];
	}

	//7E
	if((bank == 0x7E)) {
		if (address <= 0x1FFF) {
			return wramdataa[address];
		}
		if (address >= 0x2000 && address <= 0x7FFF) {
			return wramdataa[address];
		}
		if (address >= 0x8000) { 

			return ram7fa[address];
		}
	}

	//7F
	if(bank == 0x7F) {
		return ram7fa[address];
	}
	return 0;
}


unsigned char getRumbleValue(unsigned short address, unsigned char bank) {
	if(bank == 0) return wramdataa[address];
	if(bank == 1) return ram7fa[address];
	if(bank == 2) return srama[address];
	return wramdataa[address];
}
void applyCheatCodesHiROM() {
	for(int r = 0; r < 15; r++) { 
		if(Codes[r][8] == 1) { 
			unsigned short address  = (Codes[r][2] << 12) | (Codes[r][3] << 8) | (Codes[r][4] << 4) | (Codes[r][5]);
			unsigned char  bank     = (Codes[r][0] << 4)  |  Codes[r][1];
			unsigned char  data     = (Codes[r][6] << 4)  |  Codes[r][7];
			int            bankSize = 64 * 1024;

			if(saveCodes[r] == 0) { saveCodes[r] = 1; prevCodes[r] = getMemoryHi(address, bank, bankSize); }

			resetCode[r] = 1;
			setMemoryHi(address, bank, data, bankSize);
		}
		else {
			if(saveCodes[r] == 1 && resetCode[r] == 1) {
				resetCode[r] = 0;
				unsigned short address  = (Codes[r][2] << 12) | (Codes[r][3] << 8) | (Codes[r][4] << 4) | (Codes[r][5]);
				unsigned char  bank     = (Codes[r][0] << 4)  |  Codes[r][1];
				unsigned char  data     = prevCodes[r];
				int            bankSize = 64 * 1024;
				setMemoryHi(address, bank, data, bankSize);
			}
		}
	}


	for(int r = 0; r < 15; r++) { 
		if(csCodes[r][8] == 1) { 
			unsigned short address  = (csCodes[r][2] << 12) | (csCodes[r][3] << 8) | (csCodes[r][4] << 4) | (csCodes[r][5]);
			unsigned char  bank     = (csCodes[r][0] << 4)  |  csCodes[r][1];
			unsigned char  data     = (csCodes[r][6] << 4)  |  csCodes[r][7];

			if(cssaveCodes[r] == 0) { 
				cssaveCodes[r] = 1; 

				if(bank == 0) csprevCodes[r] = wramdataa[address];
				if(bank == 1) csprevCodes[r] = ram7fa[address];
				if(bank == 2) csprevCodes[r] = srama[address];
			}

			csresetCode[r] = 1;
			if(bank == 0) wramdataa[address] = data;
			if(bank == 1) ram7fa[address] = data;
			if(bank == 2) srama[address] = data;


			//setMemoryHi(address, bank, data, bankSize);
		}
		else {
			if(cssaveCodes[r] == 1 && csresetCode[r] == 1) {
				csresetCode[r] = 0;
				unsigned short address  = (csCodes[r][2] << 12) | (csCodes[r][3] << 8) | (csCodes[r][4] << 4) | (csCodes[r][5]);
				unsigned char  bank     = (csCodes[r][0] << 4)  |  csCodes[r][1];
				unsigned char  data     = csprevCodes[r];
				int            bankSize = 64 * 1024;
				if(bank == 0) wramdataa[address] = data;
				if(bank == 1) ram7fa[address] = data;
				if(bank == 2) srama[address] = data;
			}
		}
	}


	//Game Genie
	for(int r = 0; r < 15; r++) { 
		if(ggCodes[r][8] == 1) { 

			unsigned char data;
			int bankSize = 64 * 1024;

			unsigned int addr;
			char code[10];
			for(int i = 0; i < 10; i++) code[i] = '\0';
			for(int c = 0; c < 4; c++) {
				if(ggCodes[r][c] == 0)  code[c] = '0'; 
				if(ggCodes[r][c] == 1)  code[c] = '1'; 
				if(ggCodes[r][c] == 2)  code[c] = '2'; 
				if(ggCodes[r][c] == 3)  code[c] = '3'; 
				if(ggCodes[r][c] == 4)  code[c] = '4'; 
				if(ggCodes[r][c] == 5)  code[c] = '5'; 
				if(ggCodes[r][c] == 6)  code[c] = '6'; 
				if(ggCodes[r][c] == 7)  code[c] = '7'; 
				if(ggCodes[r][c] == 8)  code[c] = '8'; 
				if(ggCodes[r][c] == 9)  code[c] = '9'; 
				if(ggCodes[r][c] == 10) code[c] = 'A'; 
				if(ggCodes[r][c] == 11) code[c] = 'B'; 
				if(ggCodes[r][c] == 12) code[c] = 'C'; 
				if(ggCodes[r][c] == 13) code[c] = 'D'; 
				if(ggCodes[r][c] == 14) code[c] = 'E'; 
				if(ggCodes[r][c] == 15) code[c] = 'F'; 
			}
			code[4] = '-';
			for(int c = 0; c < 4; c++) {
				if(ggCodes[r][c+4] == 0)  code[c+5] = '0'; 
				if(ggCodes[r][c+4] == 1)  code[c+5] = '1'; 
				if(ggCodes[r][c+4] == 2)  code[c+5] = '2'; 
				if(ggCodes[r][c+4] == 3)  code[c+5] = '3'; 
				if(ggCodes[r][c+4] == 4)  code[c+5] = '4'; 
				if(ggCodes[r][c+4] == 5)  code[c+5] = '5'; 
				if(ggCodes[r][c+4] == 6)  code[c+5] = '6'; 
				if(ggCodes[r][c+4] == 7)  code[c+5] = '7'; 
				if(ggCodes[r][c+4] == 8)  code[c+5] = '8'; 
				if(ggCodes[r][c+4] == 9)  code[c+5] = '9'; 
				if(ggCodes[r][c+4] == 10) code[c+5] = 'A'; 
				if(ggCodes[r][c+4] == 11) code[c+5] = 'B'; 
				if(ggCodes[r][c+4] == 12) code[c+5] = 'C'; 
				if(ggCodes[r][c+4] == 13) code[c+5] = 'D'; 
				if(ggCodes[r][c+4] == 14) code[c+5] = 'E'; 
				if(ggCodes[r][c+4] == 15) code[c+5] = 'F'; 
			}


			const char* t = S9xGameGenieToRaw (code, addr, data);

			if(t != NULL) 

				if(ggsaveCodes[r] == 0) { 
					ggsaveCodes[r] = 1; 
					ggprevCodes[r] = getMemoryHi(((unsigned short)(addr & 0x00FFFF)), ((unsigned char)(addr >> 16)), bankSize); 
				}

				ggresetCode[r] = 1;
				setMemoryHi(((unsigned short)(addr & 0x00FFFF)), ((unsigned char)(addr >> 16)) , data, bankSize);
		}
		else {
			if(ggsaveCodes[r] == 1 && ggresetCode[r] == 1) {
				ggresetCode[r] = 0;
				unsigned int addr;
				char code[10];
				unsigned char  data;
				for(int i = 0; i < 10; i++) code[i] = '\0';
				for(int c = 0; c < 4; c++) {
					if(ggCodes[r][c] == 0)  code[c] = '0'; 
					if(ggCodes[r][c] == 1)  code[c] = '1'; 
					if(ggCodes[r][c] == 2)  code[c] = '2'; 
					if(ggCodes[r][c] == 3)  code[c] = '3'; 
					if(ggCodes[r][c] == 4)  code[c] = '4'; 
					if(ggCodes[r][c] == 5)  code[c] = '5'; 
					if(ggCodes[r][c] == 6)  code[c] = '6'; 
					if(ggCodes[r][c] == 7)  code[c] = '7'; 
					if(ggCodes[r][c] == 8)  code[c] = '8'; 
					if(ggCodes[r][c] == 9)  code[c] = '9'; 
					if(ggCodes[r][c] == 10) code[c] = 'A'; 
					if(ggCodes[r][c] == 11) code[c] = 'B'; 
					if(ggCodes[r][c] == 12) code[c] = 'C'; 
					if(ggCodes[r][c] == 13) code[c] = 'D'; 
					if(ggCodes[r][c] == 14) code[c] = 'E'; 
					if(ggCodes[r][c] == 15) code[c] = 'F'; 
				}
				code[4] = '-';
				for(int c = 0; c < 4; c++) {
					if(ggCodes[r][c+4] == 0)  code[c+5] = '0'; 
					if(ggCodes[r][c+4] == 1)  code[c+5] = '1'; 
					if(ggCodes[r][c+4] == 2)  code[c+5] = '2'; 
					if(ggCodes[r][c+4] == 3)  code[c+5] = '3'; 
					if(ggCodes[r][c+4] == 4)  code[c+5] = '4'; 
					if(ggCodes[r][c+4] == 5)  code[c+5] = '5'; 
					if(ggCodes[r][c+4] == 6)  code[c+5] = '6'; 
					if(ggCodes[r][c+4] == 7)  code[c+5] = '7'; 
					if(ggCodes[r][c+4] == 8)  code[c+5] = '8'; 
					if(ggCodes[r][c+4] == 9)  code[c+5] = '9'; 
					if(ggCodes[r][c+4] == 10) code[c+5] = 'A'; 
					if(ggCodes[r][c+4] == 11) code[c+5] = 'B'; 
					if(ggCodes[r][c+4] == 12) code[c+5] = 'C'; 
					if(ggCodes[r][c+4] == 13) code[c+5] = 'D'; 
					if(ggCodes[r][c+4] == 14) code[c+5] = 'E'; 
					if(ggCodes[r][c+4] == 15) code[c+5] = 'F'; 
				}
				const char* t = S9xGameGenieToRaw (code, addr, data);

				if(t != NULL) 
					data     = ggprevCodes[r];
				int            bankSize = 64 * 1024;
				setMemoryHi(((unsigned short)(addr & 0x00FFFF)), ((unsigned char)(addr >> 16)) , data, bankSize);
			}
		}

	}
}